/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.junit;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;
import patterntesting.runtime.junit.AbstractTester;
import patterntesting.runtime.junit.ObjectTester;
import patterntesting.runtime.monitor.ClasspathMonitor;
import patterntesting.runtime.util.Converter;

public final class ComparableTester
extends AbstractTester {
    private static final Logger LOG = LogManager.getLogger(ComparableTester.class);
    private static final ClasspathMonitor classpathMonitor = ClasspathMonitor.getInstance();

    private ComparableTester() {
    }

    public static void assertCompareTo(Comparable c1, Comparable c2) {
        int ret1 = c1.compareTo(c2);
        int ret2 = c2.compareTo(c1);
        if (c1.equals(c2)) {
            String msg = c1.getClass() + ": compareTo(..) should return 0 for equals objects";
            Assert.assertEquals((String)msg, (long)0L, (long)ret1);
            Assert.assertEquals((String)msg, (long)0L, (long)ret2);
        } else {
            String msg = c1.getClass() + ": compareTo(..) should return not 0 for not equals objects " + c1 + " and " + c2;
            Assert.assertTrue((String)msg, (ret1 != 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)msg, (ret2 != 0 ? 1 : 0) != 0);
            msg = c1.getClass() + ": <" + c2 + ">.compareTo(<" + c1 + ">) should return " + -ret2 + " (not " + ret2 + ")";
            if (ret1 < 0) {
                Assert.assertTrue((String)msg, (ret2 > 0 ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((String)msg, (ret2 < 0 ? 1 : 0) != 0);
            }
        }
        LOG.info("compareTo implementation of " + c1.getClass() + " seems to be ok");
    }

    public static void assertCompareTo(Class<? extends Comparable> clazz) throws AssertionError {
        LOG.trace("checking {}.compareTo(..)...", clazz);
        Comparable comp = (Comparable)ObjectTester.newInstanceOf(clazz);
        Comparable clone = (Comparable)ObjectTester.clone(comp);
        ComparableTester.assertCompareTo(comp, clone);
    }

    public static void assertCompareTo(Collection<Class<? extends Comparable>> classes) {
        for (Class<? extends Comparable> clazz : classes) {
            ComparableTester.assertCompareTo(clazz);
        }
    }

    public static void assertCompareTo(Package pkg) {
        assert (pkg != null);
        ComparableTester.assertCompareToOfPackage(pkg.getName());
    }

    public static void assertCompareTo(Package pkg, Pattern ... excluded) {
        assert (pkg != null);
        ComparableTester.assertCompareToOfPackage(pkg.getName(), excluded);
    }

    public static void assertCompareToOfPackage(String packageName) {
        assert (packageName != null);
        Collection<Class<? extends Comparable>> comparables = ComparableTester.getComparableClasses(packageName);
        ComparableTester.assertCompareTo(comparables);
    }

    @SafeVarargs
    public static void assertCompareToOfPackage(String packageName, Class<? extends Comparable<?>> ... excluded) {
        Collection<Class<? extends Comparable>> classes = ComparableTester.getComparableClasses(packageName);
        List<Class<? extends Comparable<?>>> excludedList = Arrays.asList(excluded);
        LOG.debug("{} will be excluded from check.", excludedList);
        ComparableTester.removeClasses(classes, excludedList);
        ComparableTester.assertCompareTo(classes);
    }

    @Deprecated
    public static void assertCompareToOfPackage(String packageName, List<Class<? extends Comparable<?>>> excluded) {
        Collection<Class<? extends Comparable>> classes = ComparableTester.getComparableClasses(packageName);
        LOG.debug("{} will be excluded from check.", excluded);
        ComparableTester.removeClasses(classes, excluded);
        ComparableTester.assertCompareTo(classes);
    }

    public static void assertCompareToOfPackage(String packageName, Pattern ... excluded) {
        Collection<Class<? extends Comparable>> classes = ComparableTester.getComparableClasses(packageName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Pattern {} will be excluded from check.", (Object)Converter.toShortString(excluded));
        }
        ComparableTester.removeClasses(classes, excluded);
        ComparableTester.assertCompareTo(classes);
    }

    private static Collection<Class<? extends Comparable>> getComparableClasses(String packageName) {
        Collection<Class<? extends Comparable>> comparables = classpathMonitor.getClassList(packageName, Comparable.class);
        return comparables;
    }
}

