/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.junit;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;
import patterntesting.annotation.check.runtime.MayReturnNull;
import patterntesting.runtime.io.LineReader;
import patterntesting.runtime.util.StringConverter;

public final class IOTester {
    private static final Logger LOG = LogManager.getLogger(IOTester.class);

    private IOTester() {
    }

    public static void assertContentEquals(InputStream in1, InputStream in2) throws AssertionError {
        IOTester.assertContentEquals(in1, in2, Charset.defaultCharset());
    }

    public static void assertContentEquals(InputStream in1, InputStream in2, Charset encoding) throws AssertionError {
        IOTester.assertContentEquals(in1, in2, encoding, new Pattern[0]);
    }

    public static void assertContentEquals(InputStream in1, InputStream in2, int from, int to) throws AssertionError {
        IOTester.assertContentEquals(in1, in2, Charset.defaultCharset(), from, to);
    }

    public static void assertContentEquals(InputStream in1, InputStream in2, Charset encoding, int from, int to) throws AssertionError {
        IOTester.assertContentEquals((Reader)new InputStreamReader(in1, encoding), (Reader)new InputStreamReader(in2, encoding), from, to);
    }

    public static void assertContentEquals(InputStream in1, InputStream in2, Pattern ... ignores) throws AssertionError {
        IOTester.assertContentEquals(in1, in2, Charset.defaultCharset(), ignores);
    }

    public static void assertContentEquals(InputStream in1, InputStream in2, Charset encoding, Pattern ... ignores) throws AssertionError {
        IOTester.assertContentEquals((Reader)new InputStreamReader(in1, encoding), (Reader)new InputStreamReader(in2, encoding), ignores);
    }

    public static void assertContentEquals(Reader r1, Reader r2) throws AssertionError {
        IOTester.assertContentEquals(new BufferedReader(r1), new BufferedReader(r2));
    }

    public static void assertContentEquals(Reader r1, Reader r2, int from, int to) throws AssertionError {
        IOTester.assertContentEquals(new LineReader(r1), new LineReader(r2), from, to);
    }

    public static void assertContentEquals(Reader r1, Reader r2, Pattern ... ignores) throws AssertionError {
        IOTester.assertContentEquals(new LineReader(r1), new LineReader(r2), ignores);
    }

    public static void assertContentEquals(Reader r1, Reader r2, StringConverter converter) throws AssertionError {
        IOTester.assertContentEquals(r1, r2, converter, new Pattern[0]);
    }

    public static void assertContentEquals(BufferedReader r1, BufferedReader r2) throws AssertionError {
        IOTester.assertContentEquals((Reader)r1, (Reader)r2, 1, Integer.MAX_VALUE);
    }

    public static void assertContentEquals(LineReader r1, LineReader r2, int from, int to) throws AssertionError {
        try {
            r1.skipLines(from - 1);
            r2.skipLines(from - 1);
            String prefix = IOTester.getMsgPrefix(r1, r2);
            int lineNo = from;
            while (lineNo <= to) {
                String line1 = r1.readLine();
                String line2 = r2.readLine();
                if (line1 == null && line2 == null) {
                    return;
                }
                Assert.assertEquals((String)(String.valueOf(prefix) + lineNo + " -"), (Object)line1, (Object)line2);
                ++lineNo;
            }
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
    }

    public static void assertContentEquals(LineReader r1, LineReader r2, Pattern ... ignores) throws AssertionError {
        try {
            String prefix = IOTester.getMsgPrefix(r1, r2);
            while (true) {
                String line1 = IOTester.nextLine(r1, ignores);
                String line2 = IOTester.nextLine(r2, ignores);
                if (line1 == null && line2 == null) {
                    return;
                }
                if (r1.getLineNumber() == r2.getLineNumber()) {
                    Assert.assertEquals((String)(String.valueOf(prefix) + r1.getLineNumber() + " -"), (Object)line1, (Object)line2);
                    continue;
                }
                Assert.assertEquals((String)(String.valueOf(prefix) + r1.getLineNumber() + "/" + r2.getLineNumber() + " -"), (Object)line1, (Object)line2);
            }
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
    }

    public static void assertContentEquals(Reader r1, Reader r2, StringConverter converter, Pattern[] ignores) {
        IOTester.assertContentEquals(new LineReader(r1), new LineReader(r2), converter, ignores);
    }

    public static void assertContentEquals(LineReader r1, LineReader r2, StringConverter converter, Pattern[] ignores) {
        try {
            String prefix = IOTester.getMsgPrefix(r1, r2);
            while (true) {
                String line1 = IOTester.nextLine(r1, ignores);
                String line2 = IOTester.nextLine(r2, ignores);
                if (line1 == null && line2 == null) {
                    return;
                }
                line1 = converter.convert(line1);
                line2 = converter.convert(line2);
                if (r1.getLineNumber() == r2.getLineNumber()) {
                    Assert.assertEquals((String)(String.valueOf(prefix) + r1.getLineNumber() + " -"), (Object)line1, (Object)line2);
                    continue;
                }
                Assert.assertEquals((String)(String.valueOf(prefix) + r1.getLineNumber() + "/" + r2.getLineNumber() + " -"), (Object)line1, (Object)line2);
            }
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
    }

    private static String getMsgPrefix(LineReader r1, LineReader r2) {
        String s1 = r1.toString();
        String s2 = r2.toString();
        if (s1.contains("@") && s2.contains("@")) {
            return "line ";
        }
        File f1 = new File(s1);
        File f2 = new File(s2);
        if (f1.exists() && f2.exists()) {
            return IOTester.getMsgPrefix(f1, f2);
        }
        return String.valueOf(s1) + " | " + s2 + ": line ";
    }

    private static String getMsgPrefix(File f1, File f2) {
        File d2;
        File d1 = f1.getParentFile();
        if (d1.equals(d2 = f2.getParentFile())) {
            return String.valueOf(f1.getName()) + " | " + f2.getName() + ": line ";
        }
        return f1 + " | " + f2 + ": line ";
    }

    @MayReturnNull
    private static String nextLine(BufferedReader reader, Pattern ... ignores) throws IOException {
        String line = reader.readLine();
        while (line != null) {
            if (!IOTester.matches(line, ignores)) {
                return line;
            }
            LOG.trace("\"{}\" maches {} and is ignored.", (Object)line, (Object)ignores);
            line = reader.readLine();
        }
        return null;
    }

    private static boolean matches(String line, Pattern[] ignores) {
        int i = 0;
        while (i < ignores.length) {
            if (ignores[i].matcher(line).matches()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

