/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import patterntesting.runtime.TimeMachineAspect;
import patterntesting.runtime.annotation.DelegateTo;
import patterntesting.runtime.junit.SmokeRunner;
import patterntesting.runtime.junit.internal.DescriptionUtils;
import patterntesting.runtime.junit.internal.ModelInitializationError;
import patterntesting.runtime.util.Converter;
import patterntesting.runtime.util.ReflectionHelper;

public class ProxyRunner
extends SmokeRunner {
    private static final Logger LOG = LogManager.getLogger(ProxyRunner.class);
    private ParentRunner<FrameworkMethod> delegateRunner;

    public ProxyRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
    }

    public final ParentRunner<FrameworkMethod> getDelegateRunner() {
        if (this.delegateRunner == null) {
            try {
                this.delegateRunner = this.createDelegateRunner();
            }
            catch (InitializationError ie) {
                throw new IllegalStateException("cannot create delegate runner", ie);
            }
        }
        return this.delegateRunner;
    }

    private ParentRunner<FrameworkMethod> createDelegateRunner() throws InitializationError {
        Class<? extends ParentRunner<FrameworkMethod>> runnerClass = this.getDelegateRunnerClass();
        try {
            Constructor<? extends ParentRunner<FrameworkMethod>> ctor = runnerClass.getDeclaredConstructor(Class.class);
            return ctor.newInstance(this.getTestClass().getJavaClass());
        }
        catch (SecurityException e) {
            throw new ModelInitializationError(e);
        }
        catch (ReflectiveOperationException e) {
            throw new ModelInitializationError(e);
        }
        catch (IllegalArgumentException e) {
            throw new ModelInitializationError(e);
        }
    }

    private Class<? extends ParentRunner<FrameworkMethod>> getDelegateRunnerClass() {
        DelegateTo delegateTo = this.getTestClass().getJavaClass().getAnnotation(DelegateTo.class);
        return delegateTo.value();
    }

    public Description getDescription() {
        Description description = this.getDelegateRunner().getDescription();
        Collection annotationList = description.getAnnotations();
        Annotation[] annotations = annotationList.toArray(new Annotation[annotationList.size()]);
        Description filtered = DescriptionUtils.createTestDescription(description, annotations);
        for (Description descr : description.getChildren()) {
            if (this.getFilter().shouldBeHidden(descr)) {
                LOG.trace("{} is hidden.", (Object)descr);
                continue;
            }
            filtered.addChild(descr);
        }
        return filtered;
    }

    @Override
    protected List<FrameworkMethod> getTestMethods() {
        return (List)ReflectionHelper.invokeMethod(this.getDelegateRunner(), "getChildren", new Object[0]);
    }

    @Override
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        try {
            if (this.shouldBeIgnored(method)) {
                notifier.fireTestIgnored(description);
                return;
            }
        }
        catch (IllegalArgumentException iae) {
            ProxyRunner.fireTestAssumptionFailed(notifier, description, iae);
            notifier.fireTestFinished(description);
            return;
        }
        long startTime = TimeMachineAspect.ajc$cflowCounter$0.isValid() || TimeMachineAspect.ajc$cflowCounter$1.isValid() ? ProxyRunner.currentTimeMillis_aroundBody1$advice(this, TimeMachineAspect.aspectOf(), null) : ProxyRunner.currentTimeMillis_aroundBody0(this);
        ReflectionHelper.invokeMethod(this.delegateRunner, "runChild", method, notifier);
        ProxyRunner.logMethod(method, (TimeMachineAspect.ajc$cflowCounter$0.isValid() || TimeMachineAspect.ajc$cflowCounter$1.isValid() ? ProxyRunner.currentTimeMillis_aroundBody3$advice(this, TimeMachineAspect.aspectOf(), null) : ProxyRunner.currentTimeMillis_aroundBody2(this)) - startTime);
    }

    private static void logMethod(FrameworkMethod method, long time) {
        LOG.info("{}.{} (" + time + " ms)", (Object)method.getMethod().getDeclaringClass().getName(), (Object)method.getName());
    }

    private static final /* synthetic */ long currentTimeMillis_aroundBody0(ProxyRunner proxyRunner) {
        return System.currentTimeMillis();
    }

    private static final /* synthetic */ long currentTimeMillis_aroundBody1$advice(ProxyRunner ajc$this, TimeMachineAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure) {
        return Converter.toDate(TimeMachineAspect.ajc$inlineAccessFieldGet$patterntesting_runtime_TimeMachineAspect$patterntesting_runtime_TimeMachineAspect$timeMachine(ajc$aspectInstance).today()).getTime();
    }

    private static final /* synthetic */ long currentTimeMillis_aroundBody2(ProxyRunner proxyRunner) {
        return System.currentTimeMillis();
    }

    private static final /* synthetic */ long currentTimeMillis_aroundBody3$advice(ProxyRunner ajc$this, TimeMachineAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure) {
        return Converter.toDate(TimeMachineAspect.ajc$inlineAccessFieldGet$patterntesting_runtime_TimeMachineAspect$patterntesting_runtime_TimeMachineAspect$timeMachine(ajc$aspectInstance).today()).getTime();
    }
}

