/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.junit;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import patterntesting.runtime.junit.ObjectTester;
import patterntesting.runtime.monitor.ClasspathMonitor;
import patterntesting.runtime.util.Converter;

public final class SerializableTester {
    private static final Logger LOG = LogManager.getLogger(SerializableTester.class);
    private static final ClasspathMonitor CLASSPATH_MONITOR = ClasspathMonitor.getInstance();

    private SerializableTester() {
    }

    public static void assertSerialization(Serializable object) throws NotSerializableException {
        Serializable deserialized = SerializableTester.deserialize(object);
        if (object instanceof Comparable) {
            ObjectTester.assertCompareTo(object, deserialized);
        }
        SerializableTester.assertNoFinalTransientAttribute(object.getClass());
    }

    public static Serializable deserialize(Serializable object) throws NotSerializableException {
        byte[] bytes = Converter.serialize(object);
        LOG.debug(object + " serialized in " + bytes.length + " bytes");
        try {
            return Converter.deserialize(bytes);
        }
        catch (ClassNotFoundException canthappen) {
            throw new IllegalArgumentException("cannot be deserialized: " + object, canthappen);
        }
    }

    public static void assertSerialization(Class<? extends Serializable> clazz) throws NotSerializableException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("checking " + clazz.getName() + " if it can be serialized...");
        }
        Serializable obj = SerializableTester.instantiate(clazz);
        SerializableTester.assertSerialization(obj);
    }

    public static void assertSerialization(Collection<Class<Serializable>> classes) throws NotSerializableException {
        for (Class<Serializable> clazz : classes) {
            SerializableTester.assertSerialization(clazz);
        }
    }

    public static void assertSerialization(Package pkg) throws NotSerializableException {
        assert (pkg != null);
        SerializableTester.assertSerializationOfPackage(pkg.getName());
    }

    public static void assertSerializationOfPackage(String packageName) throws NotSerializableException {
        assert (packageName != null);
        Collection<Class<Serializable>> classes = SerializableTester.getSerializableClasses(packageName);
        SerializableTester.assertSerialization(classes);
    }

    private static Collection<Class<Serializable>> getSerializableClasses(String packageName) {
        String[] classnames = CLASSPATH_MONITOR.getClasspathClasses();
        ArrayList<Class<Serializable>> classes = new ArrayList<Class<Serializable>>();
        int i = 0;
        while (i < classnames.length) {
            if (classnames[i].startsWith(packageName)) {
                try {
                    Class<?> clazz = Class.forName(classnames[i]);
                    if (Serializable.class.isAssignableFrom(clazz)) {
                        classes.add(clazz);
                    }
                }
                catch (ClassNotFoundException ignored) {
                    LOG.debug("Class {} is ignored:", (Object)classnames[i], (Object)ignored);
                }
                catch (LinkageError ignored) {
                    LOG.debug("Uninitializable class {} is ignored:", (Object)classnames[i], (Object)ignored);
                }
            }
            ++i;
        }
        return classes;
    }

    public static void assertNoFinalTransientAttribute(Class<? extends Serializable> clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int mod = field.getModifiers();
            if (Modifier.isFinal(mod) && Modifier.isTransient(mod)) {
                throw new AssertionError((Object)("transient trap - don't use transient and final together in: " + field));
            }
            ++n2;
        }
    }

    public static int getSizeOf(Class<Serializable> clazz) {
        Serializable obj = SerializableTester.instantiate(clazz);
        return SerializableTester.getSizeOf(obj);
    }

    public static int getSizeOf(Serializable object) {
        try {
            return Converter.serialize(object).length;
        }
        catch (NotSerializableException ex) {
            throw new IllegalArgumentException("not serializable: " + object, ex);
        }
    }

    private static Serializable instantiate(Class<? extends Serializable> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException("can't instantiate " + clazz, ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("can't access ctor of " + clazz, ex);
        }
    }
}

