/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.MultipleFailureException;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import patterntesting.runtime.junit.internal.ProfiledStatement;
import patterntesting.runtime.junit.internal.SmokeFilter;

public class SmokeRunner
extends ParentRunner<FrameworkMethod> {
    private static final Logger LOG = LogManager.getLogger(SmokeRunner.class);
    private final SmokeFilter xfilter = new SmokeFilter();

    public SmokeRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected final SmokeFilter getFilter() {
        return this.xfilter;
    }

    protected List<FrameworkMethod> getChildren() {
        Description suiteDescription = Description.createSuiteDescription((String)this.getName(), (Annotation[])this.getRunnerAnnotations());
        if (this.xfilter.shouldBeHidden(suiteDescription)) {
            Collection annotations = suiteDescription.getAnnotations();
            for (Annotation a : annotations) {
                if (!a.toString().contains("hide=true")) continue;
                throw new UnsupportedOperationException("@" + a.annotationType().getSimpleName() + "(hide=true) is only supported in method annotations of " + suiteDescription);
            }
            throw new UnsupportedOperationException("flag 'hide=true' is only supported in method annotations of " + suiteDescription);
        }
        List<FrameworkMethod> testMethods = this.getTestMethods();
        return this.filtered(testMethods);
    }

    private List<FrameworkMethod> filtered(List<FrameworkMethod> testMethods) {
        ArrayList<FrameworkMethod> nonHiddenMethods = new ArrayList<FrameworkMethod>();
        for (FrameworkMethod method : testMethods) {
            if (this.xfilter.shouldBeHidden(this.describeChild(method))) {
                LOG.trace("{} is hidden.", (Object)method);
                continue;
            }
            nonHiddenMethods.add(method);
        }
        return nonHiddenMethods;
    }

    protected List<FrameworkMethod> getTestMethods() {
        TestClass testClass = this.getTestClass();
        Class javaClass = testClass.getJavaClass();
        if (ProfiledStatement.isTestCaseClass(testClass)) {
            return SmokeRunner.getJUnit3TestMethods(javaClass);
        }
        return testClass.getAnnotatedMethods(Test.class);
    }

    protected Description describeChild(FrameworkMethod child) {
        return Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)child.getName(), (Annotation[])child.getAnnotations());
    }

    protected Statement withBeforeClasses(Statement statement) {
        List<FrameworkMethod> filtered = this.filter(BeforeClass.class);
        if (filtered.isEmpty()) {
            return statement;
        }
        return new RunBefores(statement, filtered, null);
    }

    protected Statement withAfterClasses(Statement statement) {
        List<FrameworkMethod> filtered = this.filter(AfterClass.class);
        if (filtered.isEmpty()) {
            return statement;
        }
        return new RunAfters(statement, filtered, null);
    }

    private List<FrameworkMethod> filter(Class<? extends Annotation> annotationClass) {
        List methods = this.getTestClass().getAnnotatedMethods(annotationClass);
        return this.filter(methods);
    }

    private List<FrameworkMethod> filter(List<FrameworkMethod> methods) {
        ArrayList<FrameworkMethod> filtered = new ArrayList<FrameworkMethod>();
        for (FrameworkMethod fm : methods) {
            if (!this.xfilter.shouldBeIgnored(this.describeChild(fm))) {
                filtered.add(fm);
                continue;
            }
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace(fm.getMethod() + " is filtered out");
        }
        return filtered;
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        try {
            if (this.shouldBeIgnored(method)) {
                notifier.fireTestIgnored(description);
                return;
            }
        }
        catch (IllegalArgumentException iae) {
            notifier.fireTestStarted(description);
            SmokeRunner.fireTestAssumptionFailed(notifier, description, iae);
            notifier.fireTestFinished(description);
            return;
        }
        notifier.fireTestStarted(description);
        Statement stmt = this.methodBlock(method);
        try {
            try {
                stmt.evaluate();
            }
            catch (AssumptionViolatedException ex) {
                SmokeRunner.fireTestAssumptionFailed(notifier, description, (Exception)((Object)ex));
                this.logStatement(stmt);
                notifier.fireTestFinished(description);
            }
            catch (Throwable e) {
                this.addFailure(notifier, e, description);
                this.logStatement(stmt);
                notifier.fireTestFinished(description);
            }
        }
        finally {
            this.logStatement(stmt);
            notifier.fireTestFinished(description);
        }
    }

    protected static void fireTestAssumptionFailed(RunNotifier notifier, Description description, Exception ex) {
        notifier.fireTestAssumptionFailed(new Failure(description, (Throwable)ex));
    }

    protected void logStatement(Statement stmt) {
        LOG.info("{}", (Object)stmt);
    }

    protected final boolean shouldBeIgnored(FrameworkMethod method) {
        Ignore ignore = (Ignore)method.getAnnotation(Ignore.class);
        if (ignore != null) {
            if (LOG.isDebugEnabled()) {
                String reason = ignore.value();
                if (StringUtils.isNotEmpty((CharSequence)reason)) {
                    reason = " (" + reason + ")";
                }
                LOG.debug(String.valueOf(this.getTestClass().getName()) + "." + method.getName() + " ignored" + reason);
            }
            return true;
        }
        return this.xfilter.shouldBeIgnored(this.describeChild(method));
    }

    protected final boolean shouldBeRun(FrameworkMethod method) {
        return !this.xfilter.shouldBeIgnored(this.describeChild(method));
    }

    protected final void addFailure(RunNotifier notifier, Throwable targetException, Description description) {
        if (targetException instanceof MultipleFailureException) {
            MultipleFailureException mfe = (MultipleFailureException)targetException;
            for (Throwable each : mfe.getFailures()) {
                this.addFailure(notifier, each, description);
            }
            return;
        }
        notifier.fireTestFailure(new Failure(description, targetException));
    }

    protected Statement methodBlock(FrameworkMethod method) {
        return new ProfiledStatement(this.getTestClass(), method);
    }

    public static List<FrameworkMethod> getJUnit3TestMethods(Class<?> testClass) {
        ArrayList<FrameworkMethod> children = new ArrayList<FrameworkMethod>();
        Method[] methods = testClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (SmokeRunner.isTestMethod(method)) {
                FrameworkMethod child = new FrameworkMethod(method);
                children.add(child);
            }
            ++i;
        }
        return children;
    }

    private static boolean isTestMethod(Method method) {
        int mod = method.getModifiers();
        if (method.getParameterTypes().length > 0 || Modifier.isStatic(mod)) {
            return false;
        }
        Class<?> returnType = method.getReturnType();
        if (!"void".equalsIgnoreCase(returnType.toString())) {
            return false;
        }
        if (method.getName().startsWith("test")) {
            if (Modifier.isPublic(mod)) {
                return true;
            }
            LOG.warn(method + " isn't public");
        }
        return false;
    }
}

