/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.junit.internal;

import java.lang.annotation.Annotation;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.runner.Description;
import patterntesting.annotation.check.runtime.MayReturnNull;

public abstract class DescriptionUtils {
    private static final Logger LOG = LogManager.getLogger(DescriptionUtils.class);
    private static final Pattern METHOD_NAME_PATTERN = Pattern.compile("(.*)\\((.*)\\)");

    private DescriptionUtils() {
    }

    @MayReturnNull
    public static Class<?> getTestClassOf(Description description) {
        String name = description.toString();
        Matcher matcher = Pattern.compile("(.*)\\((.*)\\)").matcher(name);
        if (matcher.matches()) {
            name = matcher.group(2);
        }
        if (name == null) {
            return null;
        }
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            LOG.debug("Cannot get test class from description \"{}\":", (Object)description, (Object)ex);
            return null;
        }
    }

    @MayReturnNull
    public static String getMethodNameOf(Description description) {
        Matcher matcher = METHOD_NAME_PATTERN.matcher(description.getDisplayName());
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static Description createTestDescription(Description description, Annotation[] annotations) {
        return Description.createTestDescription(DescriptionUtils.getTestClassOf(description), (String)description.getDisplayName(), (Annotation[])annotations);
    }
}

