/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.junit.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import junit.framework.TestCase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import patterntesting.annotation.check.runtime.MayReturnNull;
import patterntesting.runtime.TimeMachineAspect;
import patterntesting.runtime.junit.internal.JUnitHelper;
import patterntesting.runtime.util.Converter;

public class ProfiledStatement
extends Statement {
    private static final Logger LOG = LogManager.getLogger(ProfiledStatement.class);
    private final TestClass testClass;
    private final FrameworkMethod frameworkMethod;
    private long startTime;
    private long startTimeTest;
    private long startTimeAfters;
    private long endTime;

    public ProfiledStatement(TestClass testClass, FrameworkMethod frameworkMethod) {
        this.testClass = testClass;
        this.frameworkMethod = frameworkMethod;
    }

    protected final String getMethodName() {
        return this.frameworkMethod.getName();
    }

    public void evaluate() throws Throwable {
        Object target = this.testClass.getOnlyConstructor().newInstance(new Object[0]);
        try {
            try {
                this.startTimer();
                this.invokeBefores(target);
                this.startTestTimer();
                this.invokeTest(target);
                this.startAftersTimer();
                this.invokeAfters(target);
            }
            catch (InvocationTargetException ite) {
                Throwable targetException = ite.getTargetException();
                if (targetException == null) {
                    throw ite;
                }
                throw targetException;
            }
        }
        finally {
            if (this.startTimeTest == 0L) {
                this.startTestTimer();
            }
            if (this.startTimeAfters == 0L) {
                this.startAftersTimer();
            }
            this.endTimer();
        }
    }

    private void invokeTest(Object target) throws Throwable {
        Class<? extends Throwable> expected = this.getExpectedException();
        try {
            this.frameworkMethod.invokeExplosively(target, new Object[0]);
            if (expected != null && expected != Test.None.class) {
                throw new AssertionError((Object)("Expected exception: " + expected.getName()));
            }
        }
        catch (Throwable t) {
            if (expected != null && expected != Test.None.class && expected.isAssignableFrom(t.getClass())) {
                LOG.debug("Expected exception appears:", t);
                return;
            }
            throw t;
        }
    }

    @MayReturnNull
    private Class<? extends Throwable> getExpectedException() {
        Test test = (Test)this.frameworkMethod.getAnnotation(Test.class);
        if (test == null) {
            return Test.None.class;
        }
        return test.expected();
    }

    private void invokeBefores(Object target) throws Throwable {
        if (ProfiledStatement.isTestCaseClass(this.testClass)) {
            this.invoke("setUp", target);
        } else {
            List befores = this.testClass.getAnnotatedMethods(Before.class);
            this.invoke(befores, target);
        }
    }

    private void invokeAfters(Object target) throws Throwable {
        if (ProfiledStatement.isTestCaseClass(this.testClass)) {
            this.invoke("tearDown", target);
        } else {
            List afters = this.testClass.getAnnotatedMethods(After.class);
            this.invoke(afters, target);
        }
    }

    private void invoke(String methodName, Object target) throws Throwable {
        FrameworkMethod method = JUnitHelper.getFrameworkMethod(this.testClass.getJavaClass(), methodName);
        if (method != null) {
            this.invoke(method, target);
        }
    }

    private void invoke(FrameworkMethod fwkMethod, Object target) throws Throwable {
        try {
            fwkMethod.invokeExplosively(target, new Object[0]);
        }
        catch (IllegalAccessException e) {
            LOG.debug("Cannot access " + fwkMethod + ":", (Throwable)e);
            this.invokeProtected(fwkMethod, target);
        }
        catch (InvocationTargetException e) {
            throw this.getThrowableFor(fwkMethod, e);
        }
    }

    private void invokeProtected(FrameworkMethod fwkMethod, Object target) throws Throwable {
        Method method = fwkMethod.getMethod();
        method.setAccessible(true);
        try {
            method.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw this.getAssertionErrorFor(fwkMethod, e);
        }
        catch (InvocationTargetException e) {
            throw this.getThrowableFor(fwkMethod, e);
        }
    }

    private void invoke(List<FrameworkMethod> fwkMethods, Object target) throws Throwable {
        for (FrameworkMethod fwkMethod : fwkMethods) {
            this.invoke(fwkMethod, target);
        }
    }

    private AssertionError getAssertionErrorFor(FrameworkMethod method, Throwable t) {
        String detailedMessage = "invoke of " + method.getName() + "() failed\n" + t;
        return new AssertionError((Object)detailedMessage);
    }

    private Throwable getThrowableFor(FrameworkMethod fwkMethod, InvocationTargetException e) throws AssertionError {
        Throwable t = e.getTargetException();
        if (t == null) {
            throw this.getAssertionErrorFor(fwkMethod, e);
        }
        return t;
    }

    public final void startTimer() {
        this.startTime = TimeMachineAspect.ajc$cflowCounter$0.isValid() || TimeMachineAspect.ajc$cflowCounter$1.isValid() ? ProfiledStatement.currentTimeMillis_aroundBody1$advice(this, TimeMachineAspect.aspectOf(), null) : ProfiledStatement.currentTimeMillis_aroundBody0(this);
    }

    public final void startTestTimer() {
        this.startTimeTest = TimeMachineAspect.ajc$cflowCounter$0.isValid() || TimeMachineAspect.ajc$cflowCounter$1.isValid() ? ProfiledStatement.currentTimeMillis_aroundBody3$advice(this, TimeMachineAspect.aspectOf(), null) : ProfiledStatement.currentTimeMillis_aroundBody2(this);
    }

    public final void startAftersTimer() {
        this.startTimeAfters = TimeMachineAspect.ajc$cflowCounter$0.isValid() || TimeMachineAspect.ajc$cflowCounter$1.isValid() ? ProfiledStatement.currentTimeMillis_aroundBody5$advice(this, TimeMachineAspect.aspectOf(), null) : ProfiledStatement.currentTimeMillis_aroundBody4(this);
    }

    public final void endTimer() {
        this.endTime = TimeMachineAspect.ajc$cflowCounter$0.isValid() || TimeMachineAspect.ajc$cflowCounter$1.isValid() ? ProfiledStatement.currentTimeMillis_aroundBody7$advice(this, TimeMachineAspect.aspectOf(), null) : ProfiledStatement.currentTimeMillis_aroundBody6(this);
    }

    public String toString() {
        return String.valueOf(this.testClass.getName()) + "." + this.frameworkMethod.getName() + " (" + (this.startTimeTest - this.startTime) + "+" + (this.startTimeAfters - this.startTimeTest) + "+" + (this.endTime - this.startTimeAfters) + " ms)";
    }

    public static boolean isTestCaseClass(TestClass testClass) {
        return TestCase.class.isAssignableFrom(testClass.getJavaClass());
    }

    private static final /* synthetic */ long currentTimeMillis_aroundBody0(ProfiledStatement profiledStatement) {
        return System.currentTimeMillis();
    }

    private static final /* synthetic */ long currentTimeMillis_aroundBody1$advice(ProfiledStatement ajc$this, TimeMachineAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure) {
        return Converter.toDate(TimeMachineAspect.ajc$inlineAccessFieldGet$patterntesting_runtime_TimeMachineAspect$patterntesting_runtime_TimeMachineAspect$timeMachine(ajc$aspectInstance).today()).getTime();
    }

    private static final /* synthetic */ long currentTimeMillis_aroundBody2(ProfiledStatement profiledStatement) {
        return System.currentTimeMillis();
    }

    private static final /* synthetic */ long currentTimeMillis_aroundBody3$advice(ProfiledStatement ajc$this, TimeMachineAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure) {
        return Converter.toDate(TimeMachineAspect.ajc$inlineAccessFieldGet$patterntesting_runtime_TimeMachineAspect$patterntesting_runtime_TimeMachineAspect$timeMachine(ajc$aspectInstance).today()).getTime();
    }

    private static final /* synthetic */ long currentTimeMillis_aroundBody4(ProfiledStatement profiledStatement) {
        return System.currentTimeMillis();
    }

    private static final /* synthetic */ long currentTimeMillis_aroundBody5$advice(ProfiledStatement ajc$this, TimeMachineAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure) {
        return Converter.toDate(TimeMachineAspect.ajc$inlineAccessFieldGet$patterntesting_runtime_TimeMachineAspect$patterntesting_runtime_TimeMachineAspect$timeMachine(ajc$aspectInstance).today()).getTime();
    }

    private static final /* synthetic */ long currentTimeMillis_aroundBody6(ProfiledStatement profiledStatement) {
        return System.currentTimeMillis();
    }

    private static final /* synthetic */ long currentTimeMillis_aroundBody7$advice(ProfiledStatement ajc$this, TimeMachineAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure) {
        return Converter.toDate(TimeMachineAspect.ajc$inlineAccessFieldGet$patterntesting_runtime_TimeMachineAspect$patterntesting_runtime_TimeMachineAspect$timeMachine(ajc$aspectInstance).today()).getTime();
    }
}

