/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.junit.internal;

import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import patterntesting.annotation.check.runtime.MayReturnNull;
import patterntesting.runtime.NullConstants;
import patterntesting.runtime.TimeMachineAspect;
import patterntesting.runtime.annotation.Broken;
import patterntesting.runtime.annotation.IntegrationTest;
import patterntesting.runtime.annotation.RunTestOn;
import patterntesting.runtime.annotation.SkipTestOn;
import patterntesting.runtime.annotation.SmokeTest;
import patterntesting.runtime.junit.internal.DescriptionUtils;
import patterntesting.runtime.junit.internal.TestOn;
import patterntesting.runtime.util.Converter;
import patterntesting.runtime.util.Environment;

public final class SmokeFilter
extends Filter {
    private static final Logger LOG = LogManager.getLogger(SmokeFilter.class);
    private final Map<Description, Boolean> shouldRunCache = new HashMap<Description, Boolean>();
    private Date today = TimeMachineAspect.ajc$cflowCounter$0.isValid() || TimeMachineAspect.ajc$cflowCounter$1.isValid() ? SmokeFilter.init$_aroundBody1$advice(this, TimeMachineAspect.aspectOf(), null) : SmokeFilter.init$_aroundBody0(this);
    private Environment env = Environment.INSTANCE;
    private int filteredOut = 0;

    public void setToday(Date date) {
        this.today = new Date(date.getTime());
    }

    public void setEnvironment(Environment env) {
        this.env = env;
    }

    public String describe() {
        if (Environment.isPropertyEnabled("patterntesting.integrationTest")) {
            return "all tests including integration tests";
        }
        if (Environment.isPropertyEnabled("patterntesting.runSmokeTests")) {
            return "tests marked as @SmokeTest";
        }
        return "all tests (except tests marked as @Broken)";
    }

    public boolean shouldRun(Description description) {
        Boolean value = this.shouldRunCache.get(description);
        if (value != null) {
            return value;
        }
        try {
            value = Environment.SMOKE_TEST_ENABLED ? Boolean.valueOf(this.isSmokeTest(description)) : Boolean.valueOf(!this.isIntegrationTestIgnored(description));
            this.shouldRunCache.put(description, value);
            if (!value.booleanValue()) {
                ++this.filteredOut;
            }
            return value;
        }
        catch (IllegalArgumentException iae) {
            LOG.warn("{} has incomplete Annotation(s):", (Object)description, (Object)iae);
            return false;
        }
    }

    public boolean shouldBeIgnored(Description description) {
        if (Environment.SMOKE_TEST_ENABLED) {
            return !this.isSmokeTest(description);
        }
        return SmokeFilter.isSkipTestOn(description) || !SmokeFilter.isRunTestOn(description) || this.isBroken(description) || this.isIntegrationTestIgnored(description);
    }

    private boolean isIntegrationTestIgnored(Description description) {
        return !Environment.INTEGRATION_TEST_ENABLED && this.isIntegrationTest(description);
    }

    public boolean shouldBeHidden(Description description) {
        try {
            if (this.shouldBeIgnored(description)) {
                SkipTestOn skipOn = SmokeFilter.getAnnotation(description, SkipTestOn.class);
                if (skipOn != null) {
                    return skipOn.hide();
                }
                RunTestOn runOn = SmokeFilter.getAnnotation(description, RunTestOn.class);
                if (runOn != null) {
                    return runOn.hide();
                }
                Broken broken = SmokeFilter.getAnnotation(description, Broken.class);
                if (broken != null) {
                    return broken.hide();
                }
            }
        }
        catch (IllegalArgumentException ignored) {
            LOG.debug("Evaluation of {} is ignored:", (Object)description, (Object)ignored);
        }
        return false;
    }

    private boolean isIntegrationTest(Description description) {
        IntegrationTest it = SmokeFilter.getAnnotation(description, IntegrationTest.class);
        if (it != null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("{} SKIPPED because {}.", (Object)description.getDisplayName(), (Object)it.value());
            }
            return true;
        }
        return false;
    }

    private boolean isSmokeTest(Description description) {
        SmokeTest smokeTest = (SmokeTest)description.getAnnotation(SmokeTest.class);
        if (smokeTest != null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Run {} because {}.", (Object)description.getDisplayName(), (Object)smokeTest.value());
            }
            return true;
        }
        return false;
    }

    private static boolean isRunTestOn(Description description) {
        RunTestOn runOn = SmokeFilter.getAnnotation(description, RunTestOn.class);
        if (runOn == null) {
            return true;
        }
        TestOn testOn = new TestOn();
        testOn.setOsNames(runOn.value(), runOn.osName());
        testOn.setOsArchs(runOn.osArch());
        testOn.setOsVersions(runOn.osVersion());
        testOn.setHosts(runOn.host());
        testOn.setJavaVersions(runOn.javaVersion());
        testOn.setJavaVendors(runOn.javaVendor());
        testOn.setUsers(runOn.user());
        testOn.setSystemProps(runOn.property());
        testOn.setDays(runOn.day());
        testOn.setTimes(runOn.time());
        if (!testOn.isValueGiven()) {
            throw new IllegalArgumentException(description + ":  @RunTestOn has no value");
        }
        if (testOn.matches()) {
            LOG.info("{} executed {}.", (Object)description, (Object)testOn.getReason());
            return true;
        }
        return false;
    }

    private static boolean isSkipTestOn(Description description) {
        SkipTestOn skipOn = SmokeFilter.getAnnotation(description, SkipTestOn.class);
        if (skipOn == null) {
            return false;
        }
        TestOn testOn = new TestOn();
        testOn.setOsNames(skipOn.value(), skipOn.osName());
        testOn.setOsArchs(skipOn.osArch());
        testOn.setOsVersions(skipOn.osVersion());
        testOn.setHosts(skipOn.host());
        testOn.setJavaVersions(skipOn.javaVersion());
        testOn.setJavaVendors(skipOn.javaVendor());
        testOn.setUsers(skipOn.user());
        testOn.setSystemProps(skipOn.property());
        testOn.setDays(skipOn.day());
        testOn.setTimes(skipOn.time());
        if (!testOn.isValueGiven()) {
            throw new IllegalArgumentException(description + ":  @SkipTestOn has no value");
        }
        if (testOn.matches()) {
            LOG.info("{} SKIPPED because {}.", (Object)description, (Object)testOn.getReason());
            return true;
        }
        return false;
    }

    private boolean isBroken(Description description) {
        Broken broken = SmokeFilter.getAnnotation(description, Broken.class);
        return broken != null && this.isBroken(DescriptionUtils.getMethodNameOf(description), broken);
    }

    @MayReturnNull
    private static <T extends Annotation> T getAnnotation(Description description, Class<T> annotationType) {
        Annotation annotation = description.getAnnotation(annotationType);
        if (annotation != null) {
            return (T)annotation;
        }
        Class<?> testClass = DescriptionUtils.getTestClassOf(description);
        if (testClass == null) {
            LOG.debug("No test class extracted from {}.", (Object)description);
            return null;
        }
        return testClass.getAnnotation(annotationType);
    }

    public boolean isBroken(String method, Broken broken) {
        Date till;
        String why = broken.why();
        if (StringUtils.isEmpty((CharSequence)why)) {
            why = broken.value();
        }
        if (!NullConstants.NULL_DATE.equals(till = Converter.toDate(broken.till())) && till.after(this.today)) {
            LOG.info(String.valueOf(method) + "() SKIPPED till {} because {}.", (Object)broken.till(), (Object)why);
            return true;
        }
        TestOn testOn = new TestOn(this.env);
        testOn.setOsNames(broken.osName());
        testOn.setOsArchs(broken.osArch());
        testOn.setOsVersions(broken.osVersion());
        testOn.setHosts(broken.host());
        testOn.setJavaVersions(broken.javaVersion());
        testOn.setJavaVendors(broken.javaVendor());
        testOn.setUsers(broken.user());
        testOn.setSystemProps(broken.property());
        if (testOn.matches()) {
            if (NullConstants.NULL_DATE.equals(till)) {
                if (testOn.hasReason()) {
                    LOG.info("{}() SKIPPED because {}.", (Object)method, (Object)testOn.getReason());
                }
                return true;
            }
            LOG.debug("{}() started, because it should be fixed since {}.", (Object)method, (Object)broken.till());
            return false;
        }
        return false;
    }

    public boolean hasFiltered() {
        return this.filteredOut > 0;
    }

    public int getFilteredNumber() {
        return this.filteredOut;
    }

    public String toString() {
        return "filter for " + this.describe();
    }

    private static final /* synthetic */ Date init$_aroundBody0(SmokeFilter smokeFilter) {
        return new Date();
    }

    private static final /* synthetic */ Date init$_aroundBody1$advice(SmokeFilter ajc$this, TimeMachineAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure) {
        return Converter.toDate(TimeMachineAspect.ajc$inlineAccessFieldGet$patterntesting_runtime_TimeMachineAspect$patterntesting_runtime_TimeMachineAspect$timeMachine(ajc$aspectInstance).today());
    }
}

