/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.log;

import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import patterntesting.runtime.util.JoinPointHelper;

@Aspect
public abstract class AbstractLogThrowableAspect {
    public abstract Logger getLog();

    public void logThrowing(int level, Throwable t, JoinPoint jp) {
        AbstractLogThrowableAspect.logThrowing(this.getLog(), level, t, jp);
    }

    public static void logThrowing(Logger log, int level, Throwable t, JoinPoint jp) {
        String msg = String.valueOf(t.getClass().getSimpleName()) + " in " + AbstractLogThrowableAspect.toString(jp);
        switch (level) {
            case 1: {
                log.trace(msg, t);
                break;
            }
            case 2: {
                log.debug(msg, t);
                break;
            }
            case 3: {
                log.info(msg, t);
                break;
            }
            case 5: {
                log.error(msg, t);
                break;
            }
            case 6: {
                log.error(msg, t);
                break;
            }
            default: {
                log.warn(msg, t);
            }
        }
    }

    private static String toString(JoinPoint jp) {
        return String.valueOf(jp.getSignature().getName()) + JoinPointHelper.getArgsAsString(jp.getArgs());
    }
}

