/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.log;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractLogger
extends Thread
implements AutoCloseable {
    private static final Logger LOG = LogManager.getLogger(AbstractLogger.class);
    private final OutputStream logStream;

    protected AbstractLogger(OutputStream ostream) {
        this.logStream = ostream;
        Runtime.getRuntime().addShutdownHook(this);
        LOG.debug("{} is registered as shutdown hook for closing {}.", (Object)this, (Object)this.logStream);
    }

    protected static File createTempLogFile(String prefix, String suffix) {
        try {
            return File.createTempFile(prefix, suffix);
        }
        catch (IOException ioe) {
            LOG.info("Cannot create temporary log file.", (Throwable)ioe);
            return new File(String.valueOf(prefix) + suffix);
        }
    }

    protected final OutputStream getLogStream() {
        return this.logStream;
    }

    @Override
    public void run() {
        IOUtils.closeQuietly((OutputStream)this.logStream);
        LOG.debug("{} is closed.", (Object)this.logStream);
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((OutputStream)this.logStream);
        Runtime.getRuntime().removeShutdownHook(this);
        LOG.debug("{} is closed and {} removed as shutdown hook.", (Object)this.logStream, (Object)this);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " with " + this.logStream;
    }
}

