/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.log;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import patterntesting.annotation.check.runtime.NullArgsAllowed;
import patterntesting.runtime.log.ObjectRecorder;
import patterntesting.runtime.util.JoinPointHelper;
import patterntesting.runtime.util.SignatureHelper;

public class LazyObjectRecorder
extends ObjectRecorder {
    private static final Logger LOG = LogManager.getLogger(LazyObjectRecorder.class);
    private final Map<String, ValueContainer> cachedJoinpoints = new HashMap<String, ValueContainer>();

    public LazyObjectRecorder() {
    }

    public LazyObjectRecorder(File logFile) {
        super(logFile);
    }

    public LazyObjectRecorder(OutputStream ostream) {
        super(ostream);
    }

    @Override
    @NullArgsAllowed
    public void log(JoinPoint joinPoint, Object returnValue) {
        String statement = JoinPointHelper.getAsLongString(joinPoint);
        if (returnValue != null && SignatureHelper.hasReturnType(joinPoint.getSignature())) {
            try {
                this.saveLazy(statement, returnValue);
            }
            catch (IOException ioe) {
                LOG.debug("Logging failed:", (Throwable)ioe);
                LOG.info("{} = {}", (Object)statement, returnValue);
            }
        } else {
            LOG.trace("Not recorded: {}", (Object)statement);
        }
    }

    private void saveLazy(String statement, Object returnValue) throws IOException {
        ValueContainer saved = this.cachedJoinpoints.get(statement);
        if (saved == null) {
            this.cachedJoinpoints.put(statement, new ValueContainer(returnValue));
            this.save(statement, returnValue);
        } else if (ObjectUtils.equals((Object)saved.value, (Object)returnValue)) {
            LOG.trace("cached: {} = {}", (Object)statement, returnValue);
            ++saved.count;
        } else {
            this.saveCache(statement, saved);
            saved.setValue(returnValue);
            this.save(statement, returnValue);
        }
    }

    private void saveCache(String statement, ValueContainer saved) throws IOException {
        LOG.trace("saving: {} = {}", (Object)statement, (Object)saved);
        int i = 0;
        while (i < saved.count) {
            this.save(statement, saved.value);
            ++i;
        }
    }

    private static class ValueContainer {
        protected Object value;
        protected int count;

        protected ValueContainer(Object value) {
            this.value = value;
        }

        protected void setValue(Object newValue) {
            this.value = newValue;
            this.count = 0;
        }

        public String toString() {
            return this.value + " (" + this.count + " x cached)";
        }
    }
}

