/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.log;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.AbstractLogger;
import patterntesting.annotation.check.runtime.NullArgsAllowed;

public final class LogRecorder
extends AbstractLogger
implements Logger {
    private static final long serialVersionUID = 20161228L;
    private static final Logger LOG = LogManager.getLogger(LogRecorder.class);
    private final List<String> objects = new ArrayList<String>();
    private final List<Throwable> exceptions = new ArrayList<Throwable>();

    @NullArgsAllowed
    private synchronized void record(String obj, Throwable t) {
        this.objects.add(obj);
        this.exceptions.add(t);
    }

    @NullArgsAllowed
    private void record(Marker arg0, Object arg1, Throwable arg2) {
        String prefix = arg0 == null ? "" : arg0 + ": ";
        this.record(String.valueOf(prefix) + arg1, arg2);
    }

    public String getText() {
        StringBuilder text = new StringBuilder();
        for (String obj : this.objects) {
            text.append((Object)obj);
        }
        return text.toString().trim();
    }

    public String getRecord() {
        return this.getText();
    }

    public int getNumberOfRecords() {
        return this.objects.size();
    }

    public String toString() {
        String classname = ((Object)((Object)this)).getClass().getSimpleName();
        if (this.getNumberOfRecords() == 1) {
            return String.valueOf(classname) + "(\"" + this.getRecord() + "\")";
        }
        return String.valueOf(classname) + " with " + this.getNumberOfRecords() + " records";
    }

    public Level getLevel() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public boolean isEnabled(Level level, Marker marker, Message message, Throwable t) {
        return this.isEnabled(level, marker, (Object)message, t);
    }

    public boolean isEnabled(Level level, Marker marker, CharSequence message, Throwable t) {
        return this.isEnabled(level, marker, (Object)message, t);
    }

    public boolean isEnabled(Level level, Marker marker, Object message, Throwable t) {
        return this.isEnabled(level, marker, Objects.toString(message), t);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Throwable t) {
        LOG.trace("isEnabled({}, {}, \"{}\", {}) = true", (Object)level, (Object)marker, (Object)message, (Object)t);
        return true;
    }

    public boolean isEnabled(Level level, Marker marker, String message) {
        return this.isEnabled(level, marker, message, (Throwable)null);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object ... params) {
        return this.isEnabled(level, marker, String.valueOf(message) + ", " + Arrays.toString(params));
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0) {
        return this.isEnabled(level, marker, message, LogRecorder.toArray(p0));
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1) {
        return this.isEnabled(level, marker, message, LogRecorder.toArray(p0, p1));
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2) {
        return this.isEnabled(level, marker, message, LogRecorder.toArray(p0, p1, p2));
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        return this.isEnabled(level, marker, message, LogRecorder.toArray(p0, p1, p2, p3));
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        return this.isEnabled(level, marker, message, LogRecorder.toArray(p0, p1, p2, p3, p4));
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        return this.isEnabled(level, marker, message, LogRecorder.toArray(p0, p1, p2, p3, p4, p5));
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        return this.isEnabled(level, marker, message, LogRecorder.toArray(p0, p1, p2, p3, p4, p5, p6));
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        return this.isEnabled(level, marker, message, LogRecorder.toArray(p0, p1, p2, p3, p4, p5, p6, p7));
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        return this.isEnabled(level, marker, message, LogRecorder.toArray(p0, p1, p2, p3, p4, p5, p6, p7, p8));
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        return this.isEnabled(level, marker, message, LogRecorder.toArray(p0, p1, p2, p3, p4, p5, p6, p7, p8, p9));
    }

    private static Object[] toArray(Object ... args) {
        return args;
    }

    public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable t) {
        LOG.trace("logMessage(\"{}\", {}, {}, {}, {}", (Object)fqcn, (Object)level, (Object)marker, (Object)message, (Object)t);
        LOG.log(level, marker, message, t);
        this.record(marker, message, t);
    }
}

