/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.log;

import java.util.Locale;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import patterntesting.runtime.util.Converter;

public final class LogWatch
extends StopWatch {
    private static final Logger LOG = LogManager.getLogger(LogWatch.class);
    private long nanoStartTime;
    private long nanoEndTime;

    public LogWatch() {
        this.start();
    }

    public void start() {
        this.reset();
        super.start();
        this.nanoStartTime = System.nanoTime();
    }

    public void stop() {
        this.nanoEndTime = System.nanoTime();
        super.stop();
    }

    public void reset() {
        super.reset();
        this.nanoStartTime = 0L;
        this.nanoEndTime = 0L;
    }

    public long getElapsedTime() {
        return this.getTime();
    }

    @Deprecated
    public long getNanoTime() {
        return this.getTimeInNanos();
    }

    public long getTimeInNanos() {
        long endTime = this.nanoEndTime == 0L ? System.nanoTime() : this.nanoEndTime;
        long nanoTime = endTime - this.nanoStartTime;
        if (nanoTime < 0L) {
            long milliTime = this.getTime();
            LOG.info("Will use {} ms as fallback because there was an overflow with nanoTime.", (Object)milliTime);
            nanoTime = 1000000L * milliTime;
        }
        return nanoTime;
    }

    public double getTimeInMillis() {
        return (double)this.getTimeInNanos() / 1000000.0;
    }

    public String toString() {
        double millis = this.getTimeInMillis();
        if (millis > 6000000.0) {
            return super.toString();
        }
        return Converter.getTimeAsString(millis, Locale.ENGLISH);
    }
}

