/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.log;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import patterntesting.runtime.log.LogWatch;

public final class PerfLogger {
    private final Logger wrapped;
    private final ThreadLocal<LogWatch> timer = new ThreadLocal<LogWatch>(){

        @Override
        protected LogWatch initialValue() {
            return new LogWatch();
        }
    };

    public PerfLogger() {
        this(PerfLogger.class);
    }

    public PerfLogger(Class<?> clazz) {
        this(LogManager.getLogger(clazz));
    }

    public PerfLogger(Logger logger) {
        this.wrapped = logger;
    }

    public void start(String format, Object ... args) {
        this.start(3, format, args);
    }

    public void start(int level, String format, Object ... args) {
        this.log(level, format, args);
        this.timer.get().start();
    }

    public void end(String format, Object ... args) {
        this.end(3, format, args);
    }

    public void end(int logLevel, String format, Object ... args) {
        LogWatch watch = this.timer.get();
        watch.stop();
        long millis = watch.getElapsedTime();
        int level = logLevel;
        if (millis > 60000L && level < 3) {
            this.wrapped.trace("Log level will be increased from {} to 'INFO'", (Object)level);
            level = 3;
        }
        this.log(level, String.valueOf(format) + " finished after " + (Object)((Object)watch) + ".", args);
    }

    public void log(int level, String format, Object ... args) {
        switch (level) {
            case 1: {
                this.trace(format, args);
                break;
            }
            case 2: {
                this.debug(format, args);
                break;
            }
            case 3: {
                this.info(format, args);
                break;
            }
            case 4: {
                this.warn(format, args);
                break;
            }
            case 5: 
            case 6: {
                this.error(format, args);
                break;
            }
            default: {
                this.info("Level " + level + ": " + format, args);
            }
        }
    }

    public void error(String format, Object ... args) {
        this.wrapped.error(format, args);
    }

    public void warn(String format, Object ... args) {
        this.wrapped.warn(format, args);
    }

    public void info(String format, Object ... args) {
        this.wrapped.info(format, args);
    }

    public void debug(String format, Object ... args) {
        this.wrapped.debug(format, args);
    }

    public void trace(String format, Object ... args) {
        this.wrapped.trace(format, args);
    }

    public boolean isDebugEnabled() {
        return this.wrapped.isDebugEnabled();
    }
}

