/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.log;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.SourceLocation;
import patterntesting.runtime.util.Converter;
import patterntesting.runtime.util.JoinPointHelper;

public final class Trace {
    private static final Logger LOG = LogManager.getLogger(Trace.class);
    private static final int INDENT_START = Trace.calibrateStacktraceDepth();

    static {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} loaded.", Trace.class);
        } else if (LOG.isDebugEnabled()) {
            LOG.info("To see more trace information set log level to TRACE for {}.", (Object)Trace.class.getName());
        } else {
            LOG.info("To see @TraceMe information you must set log level to DEBUG for {}", (Object)Trace.class.getName());
        }
    }

    private Trace() {
    }

    private static int calibrateStacktraceDepth() {
        return Thread.currentThread().getStackTrace().length;
    }

    public static void start(JoinPoint joinpoint) {
        if (LOG.isDebugEnabled()) {
            int level = Trace.getIndentLevel();
            Trace.trace(level, "> ", joinpoint, "");
        }
    }

    public static void end(JoinPoint joinpoint) {
        if (LOG.isDebugEnabled()) {
            int level = Trace.getIndentLevel();
            Trace.trace(level, "< ", joinpoint, "");
        }
    }

    public static void end(JoinPoint joinpoint, Object result) {
        if (LOG.isDebugEnabled()) {
            int level = Trace.getIndentLevel();
            Trace.trace(level, "< ", joinpoint, " = " + Converter.toShortString(result));
        }
    }

    public static void throwing(JoinPoint joinpoint, Throwable t) {
        if (LOG.isDebugEnabled()) {
            int level = Trace.getIndentLevel();
            Trace.trace(level, "<*", joinpoint, "");
            Trace.trace(level, " *** ", t);
        }
    }

    public static void end(JoinPoint joinpoint, String suffix) {
        if (LOG.isDebugEnabled()) {
            int level = Trace.getIndentLevel();
            Trace.trace(level, "< ", joinpoint, suffix);
        }
    }

    public static void trace(JoinPoint joinpoint) {
        if (LOG.isDebugEnabled()) {
            int level = Trace.getIndentLevel();
            Trace.trace(level, " | ", joinpoint, "");
        }
    }

    private static void trace(int level, String prefix, JoinPoint joinpoint, String suffix) {
        if (LOG.isTraceEnabled()) {
            String loc = Trace.getLocation(joinpoint);
            LOG.trace(String.valueOf(Trace.indent(level)) + prefix + JoinPointHelper.getAsLongString(joinpoint) + suffix + loc);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(String.valueOf(Trace.indent(level)) + prefix + JoinPointHelper.getAsShortString(joinpoint) + suffix);
        }
    }

    private static void trace(int level, String prefix, Throwable t) {
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.valueOf(Trace.indent(level)) + prefix, t);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(String.valueOf(Trace.indent(level)) + prefix + t);
        }
    }

    private static String indent(int level) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < level) {
            buffer.append("  ");
            ++i;
        }
        return buffer.toString();
    }

    private static int getIndentLevel() {
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        return stacktrace.length - INDENT_START;
    }

    private static String getLocation(JoinPoint joinpoint) {
        SourceLocation loc = joinpoint.getSourceLocation();
        return " (" + loc.getFileName() + ":" + loc.getLine() + ")";
    }
}

