/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor;

import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.annotation.SuppressAjWarnings;
import org.aspectj.runtime.internal.AroundClosure;
import patterntesting.runtime.monitor.ProfileMonitor;
import patterntesting.runtime.monitor.ProfileStatistic;
import patterntesting.runtime.util.JoinPointHelper;

@Aspect
public abstract class AbstractProfileAspect {
    public abstract Logger getLog();

    @Pointcut(value="", argNames="")
    public abstract /* synthetic */ void ajc$pointcut$$applicationCode$530();

    @SuppressAjWarnings(value={"adviceDidNotMatch"})
    @Around(value="applicationCode()", argNames="ajc$aroundClosure")
    public Object ajc$around$patterntesting_runtime_monitor_AbstractProfileAspect$1$d15ea11e(AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        Signature sig = thisJoinPoint.getSignature();
        ProfileMonitor mon = ProfileStatistic.start(sig);
        try {
            Object object = ajc$aroundClosure.run(new Object[0]);
            return object;
        }
        finally {
            mon.stop();
            this.log(thisJoinPoint, mon.getLastValue());
        }
    }

    protected void log(JoinPoint jp, double millis) {
        this.log(jp, (long)millis);
    }

    protected void log(JoinPoint jp, long millis) {
        if (millis < 20L) {
            return;
        }
        if (millis < 200L) {
            if (this.getLog().isTraceEnabled()) {
                this.getLog().trace("+++ " + millis + "ms for " + JoinPointHelper.getAsString(jp));
            }
        } else if (millis < 2000L) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug("++++ " + millis + "ms for " + JoinPointHelper.getAsString(jp));
            }
        } else if (millis < 20000L) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info("+++++ " + millis + "ms for " + JoinPointHelper.getAsString(jp));
            }
        } else if (this.getLog().isWarnEnabled()) {
            this.getLog().warn("++++++ " + millis + "ms for " + JoinPointHelper.getAsString(jp));
        }
    }
}

