/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import patterntesting.runtime.NullConstants;
import patterntesting.runtime.annotation.ProfileMe;
import patterntesting.runtime.jmx.AnnotatedStandardMBean;
import patterntesting.runtime.jmx.Description;
import patterntesting.runtime.jmx.MBeanHelper;
import patterntesting.runtime.monitor.AbstractMonitor;
import patterntesting.runtime.monitor.AbstractProfileAspect;
import patterntesting.runtime.monitor.ClasspathMonitorMBean;
import patterntesting.runtime.monitor.ProfileAspect;
import patterntesting.runtime.monitor.ProfileMonitor;
import patterntesting.runtime.monitor.ProfileStatistic;
import patterntesting.runtime.monitor.ResourcepathMonitor;
import patterntesting.runtime.monitor.internal.ClasspathDigger;
import patterntesting.runtime.monitor.internal.DoubletDigger;
import patterntesting.runtime.util.ArchivEntry;
import patterntesting.runtime.util.ClasspathHelper;
import patterntesting.runtime.util.Converter;
import patterntesting.runtime.util.ObjectComparator;
import patterntesting.runtime.util.ReflectionHelper;
import patterntesting.runtime.util.ThreadUtil;

public class ClasspathMonitor
extends AbstractMonitor
implements ClasspathMonitorMBean {
    private static final Logger LOG;
    private static final Executor EXECUTOR;
    private static final ClasspathMonitor INSTANCE;
    private static final String[] DUMP_GETTERS;
    private final ClasspathDigger classpathDigger;
    private final DoubletDigger doubletDigger;
    private final ClassLoader cloader;
    private final String[] classpath;
    private String[] loadedClasses = new String[0];
    private final FutureTask<String[]> allClasspathClasses;
    private final FutureTask<Set<String>> unusedClasses;
    private final Map<Class<?>, URI> usedClassCache = new ConcurrentHashMap();
    private final Map<Class<?>, URI> usedClasspathCache = new ConcurrentHashMap();
    private final List<Class<?>> incompatibleClassList = new ArrayList();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    static {
        ClasspathMonitor.ajc$preClinit();
        LOG = LogManager.getLogger(ClasspathMonitor.class);
        EXECUTOR = Executors.newCachedThreadPool();
        DUMP_GETTERS = new String[]{"BootClasspath", "Classpath", "ClasspathClasses", "DoubletClasspath", "DoubletClasspathURIs", "Doublets", "LoadedClasses", "LoadedPackages", "IncompatibleClasses", "IncompatibleClasspath", "IncompatibleClasspathURIs", "UnusedClasses", "UnusedClasspath", "UsedClasspath", "UsedClasspathURIs"};
        INSTANCE = new ClasspathMonitor();
    }

    protected ClasspathMonitor() {
        this.classpathDigger = new ClasspathDigger();
        this.cloader = this.classpathDigger.getClassLoader();
        this.classpath = this.classpathDigger.getClasspath();
        this.allClasspathClasses = this.getFutureCasspathClasses();
        this.unusedClasses = this.getFutureUnusedClasses();
        this.doubletDigger = new DoubletDigger(this.classpathDigger);
    }

    private FutureTask<String[]> getFutureCasspathClasses() {
        Callable<String[]> callable = new Callable<String[]>(){

            @Override
            public String[] call() throws Exception {
                return ClasspathMonitor.this.getClasspathClassArray();
            }
        };
        FutureTask<String[]> classes = new FutureTask<String[]>(callable);
        EXECUTOR.execute(classes);
        return classes;
    }

    private FutureTask<Set<String>> getFutureUnusedClasses() {
        Callable<Set<String>> callable = new Callable<Set<String>>(){

            @Override
            public Set<String> call() throws Exception {
                return ClasspathMonitor.this.getClasspathClassSet();
            }
        };
        FutureTask<Set<String>> classes = new FutureTask<Set<String>>(callable);
        EXECUTOR.execute(classes);
        return classes;
    }

    public static ClasspathMonitor getInstance() {
        return INSTANCE;
    }

    public static void registerAsMBean() {
        ClasspathMonitor.getInstance().registerMeAsMBean();
    }

    public static void registerAsMBean(String name) {
        ClasspathMonitor.registerAsMBean(MBeanHelper.getAsObjectName(name));
    }

    public static synchronized void registerAsMBean(ObjectName name) {
        if (ClasspathMonitor.isRegisteredAsMBean()) {
            LOG.debug("MBean already registered - registerAsMBean(\"{}\") ignored.", (Object)name);
        } else {
            ClasspathMonitor.getInstance().registerMeAsMBean(name);
        }
    }

    public static void unregisterAsMBean() {
        ClasspathMonitor.getInstance().unregisterMeAsMBean();
    }

    public static boolean isRegisteredAsMBean() {
        return ClasspathMonitor.getInstance().isMBean();
    }

    @Override
    @Deprecated
    @Description(value="returns the URI of the given resource")
    public URI whichResource(String name) {
        return this.classpathDigger.whichResource(name);
    }

    @Override
    public URI whichClass(String name) {
        String resource = Converter.classToResource(name);
        return this.whichResource(resource);
    }

    public URI whichClass(Class<?> clazz) {
        LOG.trace("Searching {} in classpath.", clazz);
        URI uri = this.usedClassCache.get(clazz);
        if (uri == null) {
            uri = this.whichClass(clazz.getName());
            if (uri == null) {
                LOG.trace("{} was not found in classpath.", clazz);
            } else {
                this.usedClassCache.put(clazz, uri);
            }
        }
        LOG.trace("Searching {} in classpath finished, {} found.", clazz, (Object)uri);
        return uri;
    }

    public URI whichClassPath(String classname) {
        String resource = Converter.classToResource(classname);
        return this.whichResourcePath(resource);
    }

    public URI whichClassPath(Class<?> clazz) {
        return this.whichClassPath(clazz.getName());
    }

    public URI whichClassPath(Package p) {
        String resource = Converter.toResource(p);
        return this.whichResourcePath(resource);
    }

    public URI whichResourcePath(String resource) {
        URI uri = this.whichResource(resource);
        if (uri == null) {
            return null;
        }
        return ClasspathHelper.getParent(uri, resource);
    }

    public JarFile whichClassJar(Class<?> clazz) {
        return this.whichClassJar(clazz.getName());
    }

    public JarFile whichClassJar(String classname) {
        String resource = Converter.classToResource(classname);
        return this.whichResourceJar(resource);
    }

    public JarFile whichResourceJar(String resource) {
        return ClasspathMonitor.whichResourceJar(this.whichResourcePath(resource));
    }

    public static JarFile whichResourceJar(URI resource) {
        if (resource == null) {
            return null;
        }
        File file = Converter.toFile(resource);
        try {
            return new JarFile(file);
        }
        catch (IOException ioe) {
            LOG.debug("Cannot read " + file + ":", (Throwable)ioe);
            return null;
        }
    }

    public Enumeration<URL> getResources(String name) {
        return this.classpathDigger.getResources(name);
    }

    public static URL getResource(String name) {
        return ClasspathMonitor.class.getResource(name);
    }

    @Override
    @Deprecated
    public int getNoResources(String name) {
        return ResourcepathMonitor.getInstance().getNoResources(name);
    }

    public int getNoClasses(Class<?> cl) {
        return this.getNoClasses(cl.getName());
    }

    @Override
    public int getNoClasses(String classname) {
        return this.getNoResources(Converter.classToResource(classname));
    }

    @Override
    @Deprecated
    public boolean isDoublet(String name) {
        return this.doubletDigger.isDoublet(name);
    }

    @Override
    public boolean isDoublet(Class<?> clazz) {
        return this.doubletDigger.isDoublet(clazz);
    }

    @Override
    @Deprecated
    public URL getFirstDoublet(String name) {
        return this.getDoublet(name, 1);
    }

    @Override
    public URI getFirstDoublet(Class<?> clazz) {
        return this.getDoublet(clazz, 1);
    }

    @Override
    @Deprecated
    public URL getDoublet(String name, int nr) {
        URI uri = this.doubletDigger.getDoublet(name, nr);
        try {
            return uri.toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException("could not transfer " + uri + " to URL", ex);
        }
    }

    @Override
    public URI getDoublet(Class<?> clazz, int nr) {
        return this.doubletDigger.getDoublet(clazz, nr);
    }

    @ProfileMe
    public synchronized List<Class<?>> getDoubletList() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        return (List)ClasspathMonitor.getDoubletList_aroundBody1$advice(this, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    @Override
    public String[] getDoublets() {
        return this.doubletDigger.getDoubletClasses();
    }

    @Override
    @ProfileMe
    public String[] getDoubletClasspath() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        return (String[])ClasspathMonitor.getDoubletClasspath_aroundBody3$advice(this, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    public URI[] getDoubletClasspathURIs() {
        LOG.trace("Calculating doublet-classpath.");
        SortedSet<URI> classpathSet = this.getClasspathSet(this.getDoubletList());
        return classpathSet.toArray(new URI[classpathSet.size()]);
    }

    private SortedSet<URI> getClasspathSet(List<Class<?>> classes) {
        ArrayList<String> classResources = new ArrayList<String>();
        for (Class<?> cl : classes) {
            classResources.add(Converter.toResource(cl));
        }
        return this.classpathDigger.getResourcepathSet(classResources);
    }

    @ProfileMe
    public String getClassLoaderDetails() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        return (String)ClasspathMonitor.getClassLoaderDetails_aroundBody5$advice(this, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    private static void dumpFields(StringBuilder sbuf, Class<?> cl, Object obj) {
        AccessibleObject[] fields = cl.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        int i = 0;
        while (i < fields.length) {
            sbuf.append(fields[i]);
            sbuf.append(" = ");
            try {
                sbuf.append(((Field)fields[i]).get(obj));
            }
            catch (IllegalAccessException ex) {
                LOG.warn("Cannot access " + fields[i] + ":", (Throwable)ex);
                sbuf.append("<").append(ex).append(">");
            }
            sbuf.append('\n');
            ++i;
        }
    }

    @Override
    public boolean isClassloaderSupported() {
        return this.classpathDigger.isClassloaderSupported();
    }

    @Override
    public String getClassloaderInfo() {
        String info = this.isClassloaderSupported() ? "supported" : "unsupported";
        return String.valueOf(this.cloader.getClass().getName()) + " (" + info + ")";
    }

    @Override
    public String[] getLoadedPackages() {
        Package[] packages = this.classpathDigger.getLoadedPackageArray();
        Object[] strings = new String[packages.length];
        int i = 0;
        while (i < packages.length) {
            strings[i] = packages[i].toString();
            ++i;
        }
        Arrays.sort(strings);
        return strings;
    }

    public Package[] getLoadedPackageArray() {
        return this.classpathDigger.getLoadedPackageArray();
    }

    public String getLoadedPackagesAsString() {
        String[] packages = this.getLoadedPackages();
        StringBuilder sbuf = new StringBuilder();
        String[] stringArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            String pkg = stringArray[n2];
            sbuf.append(pkg);
            sbuf.append('\n');
            ++n2;
        }
        return sbuf.toString().trim();
    }

    public synchronized List<Class<?>> getLoadedClassList() {
        return this.classpathDigger.getLoadedClasses();
    }

    @Override
    public synchronized String[] getLoadedClasses() {
        List<Class<?>> classes = this.getLoadedClassList();
        if (classes.size() != this.loadedClasses.length) {
            this.loadedClasses = new String[classes.size()];
            int i = 0;
            while (i < this.loadedClasses.length) {
                this.loadedClasses[i] = classes.get(i).toString();
                ++i;
            }
            Arrays.sort(this.loadedClasses);
        }
        return (String[])this.loadedClasses.clone();
    }

    public String getLoadedClassesAsString() {
        List<Class<?>> classes = this.getLoadedClassList();
        Collections.sort(classes, new ObjectComparator());
        StringBuilder sbuf = new StringBuilder();
        Iterator<Class<?>> i = classes.iterator();
        while (i.hasNext()) {
            sbuf.append(i.next().toString().trim());
            sbuf.append('\n');
        }
        return sbuf.toString().trim();
    }

    @Override
    public boolean isLoaded(String classname) {
        return this.classpathDigger.isLoaded(classname);
    }

    @Override
    @ProfileMe
    public String[] getUnusedClasses() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        return (String[])ClasspathMonitor.getUnusedClasses_aroundBody7$advice(this, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    private Set<String> getUnusedClassSet() {
        try {
            return this.unusedClasses.get();
        }
        catch (InterruptedException e) {
            LOG.warn("Was interrupted before got result from {}:", this.unusedClasses, (Object)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOG.warn("Cannot execute get of {}:", this.unusedClasses, (Object)e);
        }
        return this.getClasspathClassSet();
    }

    @Override
    public String[] getClasspathClasses() {
        try {
            return this.allClasspathClasses.get();
        }
        catch (InterruptedException e) {
            LOG.warn("Was interrupted before got result from {}:", this.allClasspathClasses, (Object)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOG.warn("Cannot execute get of {}:", this.allClasspathClasses, (Object)e);
        }
        return this.getClasspathClassArray();
    }

    private Set<String> getClasspathClassSet() {
        String[] classes = this.getClasspathClasses();
        return new TreeSet<String>(Arrays.asList(classes));
    }

    public Collection<String> getClasspathClassList(String packageName) {
        ArrayList<String> classlist = new ArrayList<String>();
        String[] classes = this.getClasspathClasses();
        int i = 0;
        while (i < classes.length) {
            if (classes[i].startsWith(packageName)) {
                classlist.add(classes[i]);
            }
            ++i;
        }
        return classlist;
    }

    public <T> Collection<Class<? extends T>> getClassList(String packageName, Class<T> type) {
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        Collection<Class<? extends Object>> concreteClasses = this.getConcreteClassList(packageName);
        for (Class<? extends Object> clazz : concreteClasses) {
            if (!type.isAssignableFrom(clazz)) continue;
            classes.add(clazz);
            LOG.trace("subclass of {} found: {}", type, clazz);
        }
        return classes;
    }

    public Collection<Class<? extends Object>> getConcreteClassList(String packageName) {
        assert (packageName != null);
        Collection<String> classList = this.getClasspathClassList(packageName);
        ArrayList<Class<? extends Object>> classes = new ArrayList<Class<? extends Object>>(classList.size());
        for (String classname : classList) {
            try {
                Class<?> clazz = Class.forName(classname);
                if (!ClasspathMonitor.canBeInstantiated(clazz)) {
                    LOG.trace("{} will be ignored (can't be instantiated).", clazz);
                    continue;
                }
                classes.add(clazz);
            }
            catch (ClassNotFoundException e) {
                LOG.debug("Class '{}' is ignored because it was not found:", (Object)classname, (Object)e);
            }
            catch (NoClassDefFoundError e) {
                LOG.debug("Class '{}' is ignored because definition was not found:", (Object)classname, (Object)e);
            }
            catch (ExceptionInInitializerError ex) {
                LOG.debug("Class '{}' is ignored because it cannot be initialized:", (Object)classname, (Object)ex);
            }
        }
        return classes;
    }

    private static boolean canBeInstantiated(Class<?> clazz) {
        if (clazz.isInterface()) {
            return false;
        }
        int mod = clazz.getModifiers();
        if (Modifier.isAbstract(mod)) {
            return false;
        }
        try {
            clazz.getConstructor(new Class[0]);
            return true;
        }
        catch (SecurityException ex) {
            LOG.info("Cannot access default ctor {}:", clazz, (Object)ex);
            return false;
        }
        catch (NoSuchMethodException ex) {
            LOG.trace("Cannot get default ctor of {}:", clazz, (Object)ex);
            LOG.debug("{} has no default constructor.", clazz);
            return false;
        }
    }

    private String[] getClasspathClassArray() {
        Set<String> classSet = this.classpathDigger.getClasses();
        return classSet.toArray(new String[classSet.size()]);
    }

    @ProfileMe
    public SortedSet<URI> getUsedClasspathSet() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        return (SortedSet)ClasspathMonitor.getUsedClasspathSet_aroundBody9$advice(this, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    private URI getClasspathOf(Class<?> clazz) {
        URI classpathUri = this.usedClasspathCache.get(clazz);
        if (classpathUri == null) {
            URI classUri = this.whichClass(clazz);
            if (classUri == null) {
                LOG.trace("URI for {} was not found (probably a proxy class).", clazz);
                classpathUri = NullConstants.NULL_URI;
            } else {
                classpathUri = ClasspathHelper.getParent(classUri, clazz);
            }
            this.usedClasspathCache.put(clazz, classpathUri);
        }
        return classpathUri;
    }

    @Override
    public String[] getUsedClasspath() {
        URI[] uris = this.getUsedClasspathURIs();
        return ClasspathMonitor.toStringArray(uris);
    }

    public URI[] getUsedClasspathURIs() {
        LOG.debug("calculating used classpath...");
        SortedSet<URI> classpathSet = this.getUsedClasspathSet();
        return classpathSet.toArray(new URI[classpathSet.size()]);
    }

    @Override
    @ProfileMe
    public String[] getUnusedClasspath() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        return (String[])ClasspathMonitor.getUnusedClasspath_aroundBody11$advice(this, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    @Override
    public String[] getBootClasspath() {
        return this.classpathDigger.getBootClasspath();
    }

    @Override
    public String[] getClasspath() {
        return (String[])this.classpath.clone();
    }

    @Override
    public Long getSerialVersionUID(String classname) throws IllegalAccessException {
        try {
            Class<?> clazz = Class.forName(classname);
            return this.getSerialVersionUID(clazz);
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Class '" + classname + "' not found:", (Throwable)e);
            return null;
        }
    }

    public Long getSerialVersionUID(Class<?> clazz) throws IllegalAccessException {
        try {
            Field field = ReflectionHelper.getField(clazz, "serialVersionUID");
            return (Long)field.get(null);
        }
        catch (NoSuchFieldException ex) {
            LOG.debug(clazz + " has no serialVersionUID:", (Throwable)ex);
            return null;
        }
    }

    public String[] getManifestEntries(Class<?> clazz) {
        return this.getManifestEntries(clazz.getName());
    }

    @Override
    public String[] getManifestEntries(String classname) {
        URI classpathURI = this.whichClassPath(classname);
        if (classpathURI == null) {
            throw new IllegalArgumentException(String.valueOf(classname) + " not found in classpath");
        }
        File path = Converter.toFile(classpathURI);
        return this.getManifestEntries(path);
    }

    private String[] getManifestEntries(File path) {
        if (path.isFile()) {
            try {
                return this.getManifestEntries(new JarFile(path));
            }
            catch (IOException ioe) {
                LOG.info("No manifest found in " + path + ":", (Throwable)ioe);
                return new String[0];
            }
        }
        File manifestFile = new File(path, "META-INF/MANIFEST.MF");
        if (!manifestFile.exists()) {
            LOG.debug("File '{}' does not exist.", (Object)manifestFile);
            return new String[0];
        }
        try {
            FileInputStream istream = new FileInputStream(manifestFile);
            Manifest manifest = new Manifest(istream);
            IOUtils.closeQuietly((InputStream)istream);
            return this.getManifestEntries(manifest);
        }
        catch (IOException ioe) {
            LOG.info("Cannot read '" + manifestFile + "':", (Throwable)ioe);
            return new String[0];
        }
    }

    private String[] getManifestEntries(JarFile jarfile) {
        Manifest manifest;
        try {
            manifest = jarfile.getManifest();
        }
        catch (IOException ioe) {
            LOG.info("No manifest found in '" + jarfile + "':", (Throwable)ioe);
            return new String[0];
        }
        if (manifest == null) {
            LOG.debug("No manifest found in '{}'.", (Object)jarfile);
            return new String[0];
        }
        return this.getManifestEntries(manifest);
    }

    private String[] getManifestEntries(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        String[] manifestEntries = new String[attributes.size()];
        Set<Map.Entry<Object, Object>> entries = attributes.entrySet();
        Iterator<Map.Entry<Object, Object>> iterator = entries.iterator();
        int i = 0;
        while (i < manifestEntries.length) {
            Map.Entry<Object, Object> entry = iterator.next();
            manifestEntries[i] = entry.getKey() + ": " + entry.getValue();
            ++i;
        }
        return manifestEntries;
    }

    @ProfileMe
    public synchronized List<Class<?>> getIncompatibleClassList() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        return (List)ClasspathMonitor.getIncompatibleClassList_aroundBody13$advice(this, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    @Override
    public String[] getIncompatibleClasses() {
        LOG.debug("Calculating incompatible classes...");
        List<Class<?>> classList = this.getIncompatibleClassList();
        String[] classes = new String[classList.size()];
        int i = 0;
        while (i < classes.length) {
            classes[i] = classList.get(i).toString();
            ++i;
        }
        return classes;
    }

    @Override
    public String[] getIncompatibleClasspath() {
        URI[] classpathURIs = this.getIncompatibleClasspathURIs();
        return ClasspathMonitor.toStringArray(classpathURIs);
    }

    public URI[] getIncompatibleClasspathURIs() {
        LOG.debug("calculating incompatible-classpath...");
        SortedSet<URI> classpathSet = this.getClasspathSet(this.getIncompatibleClassList());
        return classpathSet.toArray(new URI[classpathSet.size()]);
    }

    public static synchronized void addAsShutdownHook() {
        INSTANCE.addMeAsShutdownHook();
    }

    public static synchronized void removeAsShutdownHook() {
        INSTANCE.removeMeAsShutdownHook();
    }

    @Override
    public void logMe() {
        try {
            StringWriter writer = new StringWriter();
            this.dumpMe(writer);
            LOG.info(writer.toString());
        }
        catch (IOException cannothappen) {
            LOG.warn("Will only dump classloader info:", (Throwable)cannothappen);
            LOG.info(this.getClassloaderInfo());
        }
    }

    @Override
    public void dumpMe(File dumpDir) throws IOException {
        this.dump(dumpDir, DUMP_GETTERS);
        this.dumpClassloaderInfo(dumpDir);
        this.copyResource("CpMonREADME.txt", new File(dumpDir, "README.txt"));
    }

    private void dumpMe(Writer unbuffered) throws IOException {
        BufferedWriter writer = new BufferedWriter(unbuffered);
        this.dump(writer, DUMP_GETTERS);
        this.dumpClassloaderInfo(writer);
        writer.flush();
    }

    private void dumpClassloaderInfo(File dir) throws IOException {
        File dumpFile = new File(dir, "ClassloaderInfo.txt");
        LOG.debug("Dumping classloader info to {}...", (Object)dumpFile);
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(dumpFile), "UTF-8");){
            this.dumpClassloaderInfo(new BufferedWriter(writer));
            writer.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void dumpClassloaderInfo(BufferedWriter writer) throws IOException {
        ClasspathMonitor.dumpHeadline(writer, "ClassloaderInfo");
        writer.write(this.getClassloaderInfo());
        writer.newLine();
        writer.newLine();
        ClasspathMonitor.dumpHeadline(writer, "=== ClassLoaderDetails ===");
        writer.write(this.getClassLoaderDetails());
        writer.newLine();
        ClasspathMonitor.dumpHeadline(writer, "ClassloaderInfo (end)");
        writer.flush();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " for " + this.cloader;
    }

    public static void main(String[] args) throws JMException {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName name = new ObjectName("patterntesting.runtime.monitor:type=ClasspathMonitor");
        ClasspathMonitor hello = new ClasspathMonitor();
        AnnotatedStandardMBean mbean = new AnnotatedStandardMBean(hello, ClasspathMonitorMBean.class);
        mbs.registerMBean(mbean, name);
        ThreadUtil.sleep(300, TimeUnit.SECONDS);
    }

    @Override
    public boolean isMultiThreadingEnabled() {
        return this.doubletDigger.isMultiThreadingEnabled();
    }

    @Override
    public void setMultiThreadingEnabled(boolean enabled) {
        this.doubletDigger.setMultiThreadingEnabled(enabled);
    }

    private static final /* synthetic */ Object getDoubletList_aroundBody1$advice(ClasspathMonitor ajc$this, JoinPoint thisJoinPoint, AbstractProfileAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        Signature sig = thisJoinPoint2.getSignature();
        ProfileMonitor mon = ProfileStatistic.start(sig);
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            List list = ajc$this.doubletDigger.getDoubletClassList();
            return list;
        }
        finally {
            mon.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log(ajc$aspectInstance, thisJoinPoint2, mon.getLastValue());
        }
    }

    private static final /* synthetic */ String[] getDoubletClasspath_aroundBody2(ClasspathMonitor ajc$this, JoinPoint joinPoint) {
        URI[] classpathURIs = ajc$this.getDoubletClasspathURIs();
        return ClasspathMonitor.toStringArray(classpathURIs);
    }

    private static final /* synthetic */ Object getDoubletClasspath_aroundBody3$advice(ClasspathMonitor ajc$this, JoinPoint thisJoinPoint, AbstractProfileAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        Signature sig = thisJoinPoint2.getSignature();
        ProfileMonitor mon = ProfileStatistic.start(sig);
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            String[] stringArray = ClasspathMonitor.getDoubletClasspath_aroundBody2(ajc$this, thisJoinPoint);
            return stringArray;
        }
        finally {
            mon.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log(ajc$aspectInstance, thisJoinPoint2, mon.getLastValue());
        }
    }

    private static final /* synthetic */ String getClassLoaderDetails_aroundBody4(ClasspathMonitor ajc$this, JoinPoint joinPoint) {
        StringBuilder sbuf = new StringBuilder("dump of " + ajc$this.cloader + ":\n");
        Class<?> cl = ajc$this.cloader.getClass();
        while (cl != null) {
            sbuf.append('\t');
            ClasspathMonitor.dumpFields(sbuf, cl, ajc$this.cloader);
            cl = cl.getSuperclass();
        }
        return sbuf.toString().trim();
    }

    private static final /* synthetic */ Object getClassLoaderDetails_aroundBody5$advice(ClasspathMonitor ajc$this, JoinPoint thisJoinPoint, AbstractProfileAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        Signature sig = thisJoinPoint2.getSignature();
        ProfileMonitor mon = ProfileStatistic.start(sig);
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            String string = ClasspathMonitor.getClassLoaderDetails_aroundBody4(ajc$this, thisJoinPoint);
            return string;
        }
        finally {
            mon.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log(ajc$aspectInstance, thisJoinPoint2, mon.getLastValue());
        }
    }

    private static final /* synthetic */ String[] getUnusedClasses_aroundBody6(ClasspathMonitor ajc$this, JoinPoint joinPoint) {
        List<Class<?>> classes = ajc$this.getLoadedClassList();
        ArrayList<String> used = new ArrayList<String>();
        Set<String> unusedSet = ajc$this.getUnusedClassSet();
        for (Class<?> cl : classes) {
            String classname = cl.getName();
            if (!unusedSet.contains(classname)) continue;
            used.add(classname);
        }
        unusedSet.removeAll(used);
        String[] unused = new String[unusedSet.size()];
        unusedSet.toArray(unused);
        return unused;
    }

    private static final /* synthetic */ Object getUnusedClasses_aroundBody7$advice(ClasspathMonitor ajc$this, JoinPoint thisJoinPoint, AbstractProfileAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        Signature sig = thisJoinPoint2.getSignature();
        ProfileMonitor mon = ProfileStatistic.start(sig);
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            String[] stringArray = ClasspathMonitor.getUnusedClasses_aroundBody6(ajc$this, thisJoinPoint);
            return stringArray;
        }
        finally {
            mon.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log(ajc$aspectInstance, thisJoinPoint2, mon.getLastValue());
        }
    }

    private static final /* synthetic */ SortedSet getUsedClasspathSet_aroundBody8(ClasspathMonitor ajc$this, JoinPoint joinPoint) {
        List<Class<?>> loadedClassList = ajc$this.getLoadedClassList();
        TreeSet<URI> usedClasspathSet = new TreeSet<URI>();
        for (Class<?> clazz : loadedClassList) {
            URI classpathUri = ajc$this.getClasspathOf(clazz);
            if (NullConstants.NULL_URI.equals(classpathUri)) continue;
            usedClasspathSet.add(classpathUri);
        }
        return usedClasspathSet;
    }

    private static final /* synthetic */ Object getUsedClasspathSet_aroundBody9$advice(ClasspathMonitor ajc$this, JoinPoint thisJoinPoint, AbstractProfileAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        Signature sig = thisJoinPoint2.getSignature();
        ProfileMonitor mon = ProfileStatistic.start(sig);
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            SortedSet sortedSet = ClasspathMonitor.getUsedClasspathSet_aroundBody8(ajc$this, thisJoinPoint);
            return sortedSet;
        }
        finally {
            mon.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log(ajc$aspectInstance, thisJoinPoint2, mon.getLastValue());
        }
    }

    private static final /* synthetic */ String[] getUnusedClasspath_aroundBody10(ClasspathMonitor ajc$this, JoinPoint joinPoint) {
        LOG.debug("calculating unused classpath...");
        TreeSet<String> unused = new TreeSet<String>();
        LOG.trace(Arrays.class + " loaded (to get corrected used classpath");
        Object[] used = ajc$this.getUsedClasspath();
        int i = 0;
        while (i < ajc$this.classpath.length) {
            String path = new File(ajc$this.classpath[i]).getAbsolutePath();
            if (Arrays.binarySearch(used, path) < 0) {
                unused.add(path);
            }
            ++i;
        }
        String[] a = new String[unused.size()];
        return unused.toArray(a);
    }

    private static final /* synthetic */ Object getUnusedClasspath_aroundBody11$advice(ClasspathMonitor ajc$this, JoinPoint thisJoinPoint, AbstractProfileAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        Signature sig = thisJoinPoint2.getSignature();
        ProfileMonitor mon = ProfileStatistic.start(sig);
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            String[] stringArray = ClasspathMonitor.getUnusedClasspath_aroundBody10(ajc$this, thisJoinPoint);
            return stringArray;
        }
        finally {
            mon.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log(ajc$aspectInstance, thisJoinPoint2, mon.getLastValue());
        }
    }

    private static final /* synthetic */ List getIncompatibleClassList_aroundBody12(ClasspathMonitor ajc$this, JoinPoint joinPoint) {
        List<Class<?>> doublets = ajc$this.getDoubletList();
        block2: for (Class<?> clazz : doublets) {
            if (ajc$this.incompatibleClassList.contains(clazz)) continue;
            String resource = Converter.classToResource(clazz.getName());
            Enumeration<URL> resources = ajc$this.getResources(resource);
            try {
                URL url = resources.nextElement();
                ArchivEntry archivEntry = new ArchivEntry(url);
                while (resources.hasMoreElements()) {
                    url = resources.nextElement();
                    ArchivEntry doubletEntry = new ArchivEntry(url);
                    if (!archivEntry.equals(doubletEntry)) continue;
                    ajc$this.incompatibleClassList.add(clazz);
                    continue block2;
                }
            }
            catch (NoSuchElementException nse) {
                LOG.warn("{} is not added to incompatible class list:", clazz, (Object)nse);
            }
        }
        return Collections.unmodifiableList(ajc$this.incompatibleClassList);
    }

    private static final /* synthetic */ Object getIncompatibleClassList_aroundBody13$advice(ClasspathMonitor ajc$this, JoinPoint thisJoinPoint, AbstractProfileAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        Signature sig = thisJoinPoint2.getSignature();
        ProfileMonitor mon = ProfileStatistic.start(sig);
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            List list = ClasspathMonitor.getIncompatibleClassList_aroundBody12(ajc$this, thisJoinPoint);
            return list;
        }
        finally {
            mon.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log(ajc$aspectInstance, thisJoinPoint2, mon.getLastValue());
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ClasspathMonitor.java", ClasspathMonitor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "getDoubletList", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "java.util.List"), 572);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDoubletClasspath", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "[Ljava.lang.String;"), 594);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassLoaderDetails", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "java.lang.String"), 625);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUnusedClasses", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "[Ljava.lang.String;"), 797);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUsedClasspathSet", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "java.util.SortedSet"), 976);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUnusedClasspath", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "[Ljava.lang.String;"), 1036);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "getIncompatibleClassList", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "java.util.List"), 1273);
    }
}

