/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor;

import java.net.URI;
import java.net.URL;
import java.util.NoSuchElementException;
import patterntesting.runtime.jmx.Description;
import patterntesting.runtime.monitor.AbstractMonitorMBean;

@Description(value="Classpath Monitor to be able to inspect the classpath and to find doublets")
public interface ClasspathMonitorMBean
extends AbstractMonitorMBean {
    @Deprecated
    @Description(value="returns the URI of the given resource")
    public URI whichResource(String var1);

    @Description(value="return the URI if the given class")
    public URI whichClass(String var1);

    @Deprecated
    @Description(value="how often the given resource is found in the classpath")
    public int getNoResources(String var1);

    @Description(value="how often the given class is found in the classpath")
    public int getNoClasses(String var1);

    @Deprecated
    @Description(value="is the given classname or resource found more than once in the classpath?")
    public boolean isDoublet(String var1) throws NoSuchElementException;

    @Description(value="is the given classname or resource found more than once in the classpath?")
    public boolean isDoublet(Class<?> var1);

    @Deprecated
    @Description(value="returns the first doublet of the given classname or resource")
    public URL getFirstDoublet(String var1);

    @Description(value="returns the first doublet of the given classname or resource")
    public URI getFirstDoublet(Class<?> var1);

    @Description(value="returns a sorted array of all found doublets")
    public String[] getDoublets();

    @Description(value="returns the classpath where doublets were found")
    public String[] getDoubletClasspath();

    @Deprecated
    @Description(value="returns the n'th doublet of the given classname or resource")
    public URL getDoublet(String var1, int var2);

    @Description(value="returns the n'th doublet of the given classname or resource")
    public URI getDoublet(Class<?> var1, int var2);

    @Description(value="returns an array of all loaded packages")
    public String[] getLoadedPackages();

    @Description(value="returns an array of all loaded classes")
    public String[] getLoadedClasses();

    @Description(value="is the given classname already loaded?")
    public boolean isLoaded(String var1);

    @Description(value="returns all classes which are not yet loaded")
    public String[] getUnusedClasses();

    @Description(value="returns the classpath with the loaded classes")
    public String[] getUsedClasspath();

    @Description(value="returns the classpath which were not yet used")
    public String[] getUnusedClasspath();

    @Description(value="return ths boot classpath")
    public String[] getBootClasspath();

    @Description(value="returns the complete classpath which is seen by the application")
    public String[] getClasspath();

    @Description(value="returns all classes of the classpath")
    public String[] getClasspathClasses();

    @Description(value="returns the servialSerialVersionUID of the given class")
    public Long getSerialVersionUID(String var1) throws IllegalAccessException;

    @Description(value="return the manifest entries for the given class")
    public String[] getManifestEntries(String var1);

    @Description(value="returns the doublet classes with different byte codes")
    public String[] getIncompatibleClasses();

    @Description(value="returns the classpath where incompatible classes were found")
    public String[] getIncompatibleClasspath();

    @Description(value="returns true for classloader which are known and tested")
    public boolean isClassloaderSupported();

    @Description(value="returns some infos about the found classloader")
    public String getClassloaderInfo();

    public boolean isMultiThreadingEnabled();

    @Description(value="experimental, don't change it!")
    public void setMultiThreadingEnabled(boolean var1);
}

