/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.ConstructorSignature;
import org.aspectj.lang.reflect.MethodSignature;
import patterntesting.annotation.check.runtime.MayReturnNull;
import patterntesting.runtime.annotation.DontProfileMe;
import patterntesting.runtime.jmx.MBeanHelper;
import patterntesting.runtime.monitor.JamonMonitorFactory;
import patterntesting.runtime.monitor.ProfileMonitor;
import patterntesting.runtime.monitor.ProfileMonitorFactory;
import patterntesting.runtime.monitor.ProfileStatisticMBean;
import patterntesting.runtime.monitor.SimpleProfileMonitor;
import patterntesting.runtime.monitor.SimpleProfileMonitorFactory;
import patterntesting.runtime.util.Environment;
import patterntesting.runtime.util.SignatureHelper;

public class ProfileStatistic
extends Thread
implements ProfileStatisticMBean {
    private static final ProfileStatistic INSTANCE;
    private static final Logger LOG;
    private ObjectName mbeanName = MBeanHelper.getAsObjectName(this.getClass());
    private final ProfileMonitorFactory factory;
    private static final boolean JAMON_AVAILABLE;

    static {
        LOG = LogManager.getLogger(ProfileStatistic.class);
        JAMON_AVAILABLE = Environment.isJamonAvailable();
        INSTANCE = new ProfileStatistic("root");
    }

    public static ProfileStatistic getInstance() {
        return INSTANCE;
    }

    protected ProfileStatistic(String rootLabel) {
        SimpleProfileMonitor rootMonitor = new SimpleProfileMonitor(rootLabel);
        MBeanHelper.registerMBean(this.mbeanName, (Object)this);
        this.factory = JAMON_AVAILABLE ? new JamonMonitorFactory(rootMonitor) : new SimpleProfileMonitorFactory(rootMonitor);
        this.factory.setMaxNumMonitors(100);
    }

    public static void registerAsMBean(String name) {
        INSTANCE.registerMeAsMBean(name);
    }

    protected void registerMeAsMBean(String name) {
        this.registerMeAsMBean(MBeanHelper.getAsObjectName(name));
    }

    private void registerMeAsMBean(ObjectName name) {
        MBeanHelper.unregisterMBean(this.mbeanName);
        MBeanHelper.registerMBean(name, (Object)this);
        LOG.info("{} no longer registered as MBean '{}' but as MBean '{}'.", (Object)this.getClass().getSimpleName(), (Object)this.mbeanName, (Object)name);
        this.mbeanName = name;
    }

    public static void addAsShutdownHook() {
        ProfileStatistic.addAsShutdownHook(INSTANCE);
    }

    protected static void addAsShutdownHook(ProfileStatistic hook) {
        Runtime.getRuntime().addShutdownHook(hook);
        if (LOG.isDebugEnabled()) {
            LOG.debug(hook + " registered as shutdown hook");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Class<ProfileStatistic> clazz = ProfileStatistic.class;
        synchronized (ProfileStatistic.class) {
            ArrayList<String> labels = new ArrayList<String>();
            ProfileMonitor[] monitors = this.getMonitors();
            int i = 0;
            while (i < monitors.length) {
                if (monitors[i].getHits() == 0) {
                    labels.add(monitors[i].getLabel());
                }
                ++i;
            }
            this.factory.addMonitors(labels);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void resetRootMonitor() {
        this.factory.reset();
    }

    public void init(Class<?> cl) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("initializing monitors for " + cl + "...");
        }
        INSTANCE.init(cl, cl.getMethods());
        INSTANCE.init(cl.getConstructors());
    }

    private void init(Class<?> cl, Method[] methods) {
        int i = 0;
        while (i < methods.length) {
            Class<?> declaring = methods[i].getDeclaringClass();
            if (cl.equals(declaring)) {
                this.init(methods[i]);
            } else if (LOG.isTraceEnabled()) {
                LOG.trace(methods[i] + " not defined in " + cl + " -> no monitor initialized");
            }
            ++i;
        }
    }

    private void init(Method method) {
        if (method.getAnnotation(DontProfileMe.class) != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("@DontProfileMe " + method + " is ignored");
            }
            return;
        }
        MethodSignature sig = SignatureHelper.getAsSignature(method);
        ProfileMonitor mon = this.getMonitor((Signature)sig);
        if (LOG.isTraceEnabled()) {
            LOG.trace(mon + " initialized");
        }
    }

    private void init(Constructor<?>[] ctors) {
        int i = 0;
        while (i < ctors.length) {
            this.init(ctors[i]);
            ++i;
        }
    }

    private void init(Constructor<?> ctor) {
        if (ctor.getAnnotation(DontProfileMe.class) != null) {
            LOG.trace("@DontProfileMe {} is ignored", ctor);
            return;
        }
        ConstructorSignature sig = SignatureHelper.getAsSignature(ctor);
        ProfileMonitor mon = this.getMonitor((Signature)sig);
        LOG.trace("{} initialized", (Object)mon);
    }

    public ObjectName getMBeanName() {
        return this.mbeanName;
    }

    @Override
    public void setMaxSize(int size) {
        this.factory.setMaxNumMonitors(size);
    }

    @Override
    public int getMaxSize() {
        return this.factory.getMaxNumMonitors();
    }

    @Override
    public void run() {
        try {
            this.dumpStatistic();
        }
        catch (IOException ioe) {
            LOG.warn("Cannot dump statistic to temporary file:", (Throwable)ioe);
        }
    }

    public static ProfileMonitor start(Signature sig) {
        return INSTANCE.startProfileMonitorFor(sig);
    }

    public ProfileMonitor startProfileMonitorFor(Signature sig) {
        return this.startProfileMonitorFor(SignatureHelper.getAsString(sig));
    }

    public ProfileMonitor startProfileMonitorFor(String sig) {
        ProfileMonitor mon = this.factory.getMonitor(sig);
        mon.start();
        return mon;
    }

    private synchronized ProfileMonitor getMonitor(Signature sig) {
        return this.factory.getMonitor(SignatureHelper.getAsString(sig));
    }

    public ProfileMonitor[] getMonitors() {
        return this.factory.getMonitors();
    }

    protected final ProfileMonitor[] getSortedMonitors() {
        Object[] monitors = this.getMonitors();
        Arrays.sort(monitors);
        return monitors;
    }

    private ProfileMonitor getMaxHitsMonitor() {
        ProfileMonitor[] monitors = this.getMonitors();
        ProfileMonitor max = new SimpleProfileMonitor();
        int i = 0;
        while (i < monitors.length) {
            if (monitors[i].getHits() >= max.getHits()) {
                max = monitors[i];
            }
            ++i;
        }
        return max;
    }

    @Override
    public int getMaxHits() {
        return this.getMaxHitsMonitor().getHits();
    }

    @Override
    public String getMaxHitsLabel() {
        return this.getMaxHitsMonitor().getLabel();
    }

    @Override
    public String getMaxHitsStatistic() {
        return this.getMaxHitsMonitor().toShortString();
    }

    private ProfileMonitor getMaxTotalMonitor() {
        ProfileMonitor[] monitors = this.getMonitors();
        ProfileMonitor max = new SimpleProfileMonitor();
        int i = 0;
        while (i < monitors.length) {
            if (monitors[i].getTotal() >= max.getTotal()) {
                max = monitors[i];
            }
            ++i;
        }
        return max;
    }

    @Override
    public double getMaxTotal() {
        return this.getMaxTotalMonitor().getTotal();
    }

    @Override
    public String getMaxTotalLabel() {
        return this.getMaxTotalMonitor().getLabel();
    }

    @Override
    public String getMaxTotalStatistic() {
        return this.getMaxTotalMonitor().toShortString();
    }

    private ProfileMonitor getMaxAvgMonitor() {
        ProfileMonitor[] monitors = this.getMonitors();
        ProfileMonitor max = monitors[0];
        double maxValue = 0.0;
        int i = 0;
        while (i < monitors.length) {
            double value = monitors[i].getAvg();
            if (!Double.isNaN(value) && value > maxValue) {
                maxValue = value;
                max = monitors[i];
            }
            ++i;
        }
        return max;
    }

    protected ProfileMonitor getRootMonitor() {
        return this.factory.getRootMonitor();
    }

    @Override
    public double getMaxAvg() {
        return this.getMaxAvgMonitor().getAvg();
    }

    @Override
    public String getMaxAvgLabel() {
        return this.getMaxAvgMonitor().getLabel();
    }

    @Override
    public String getMaxAvgStatistic() {
        return this.getMaxAvgMonitor().toShortString();
    }

    private ProfileMonitor getMaxMaxMonitor() {
        ProfileMonitor[] monitors = this.getMonitors();
        ProfileMonitor max = new SimpleProfileMonitor();
        int i = 0;
        while (i < monitors.length) {
            if (monitors[i].getMax() >= max.getMax()) {
                max = monitors[i];
            }
            ++i;
        }
        return max;
    }

    @Override
    public double getMaxMax() {
        return this.getMaxMaxMonitor().getMax();
    }

    @Override
    public String getMaxMaxLabel() {
        return this.getMaxMaxMonitor().getLabel();
    }

    @Override
    public String getMaxMaxStatistic() {
        return this.getMaxMaxMonitor().toShortString();
    }

    @Override
    public TabularData getStatistics() {
        try {
            String[] itemNames = new String[]{"Label", "Units", "Hits", "Avg", "Total", "Min", "Max"};
            String[] itemDescriptions = new String[]{"method name", "time unit (e.g. ms)", "number of hits", "average time", "total time", "minimal time", "maximal time"};
            OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.DOUBLE};
            CompositeType rowType = new CompositeType("propertyType", "property entry", itemNames, itemDescriptions, itemTypes);
            TabularDataSupport data = MBeanHelper.createTabularDataSupport(rowType, itemNames);
            ProfileMonitor[] monitors = this.getSortedMonitors();
            int i = 0;
            while (i < monitors.length) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("Label", monitors[i].getLabel());
                map.put("Units", monitors[i].getUnits());
                map.put("Hits", monitors[i].getHits());
                map.put("Avg", monitors[i].getAvg());
                map.put("Total", monitors[i].getTotal());
                map.put("Min", monitors[i].getMin());
                map.put("Max", monitors[i].getMax());
                CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
                data.put(compData);
                ++i;
            }
            return data;
        }
        catch (OpenDataException e) {
            LOG.error("can't create TabularData for log settings", (Throwable)e);
            return null;
        }
    }

    @Override
    public void logStatistic() {
        ProfileMonitor[] monitors;
        LOG.info("----- Profile Statistic -----");
        ProfileMonitor[] profileMonitorArray = monitors = this.getSortedMonitors();
        int n = monitors.length;
        int n2 = 0;
        while (n2 < n) {
            ProfileMonitor profMon = profileMonitorArray[n2];
            LOG.info("{}", (Object)profMon);
            ++n2;
        }
    }

    @Override
    public File dumpStatistic() throws IOException {
        File dumpFile = File.createTempFile(this.getClass().getSimpleName(), ".csv");
        this.dumpStatisticTo(dumpFile);
        return dumpFile;
    }

    @Override
    public void dumpStatistic(String filename) throws IOException {
        this.dumpStatisticTo(new File(filename));
    }

    public void dumpStatisticTo(File dumpFile) throws IOException {
        ProfileMonitor[] monitors = this.getSortedMonitors();
        if (monitors.length == 0) {
            LOG.debug("No profiling data available.");
            return;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dumpFile), StandardCharsets.UTF_8));){
            writer.write(monitors[0].toCsvHeadline());
            writer.newLine();
            ProfileMonitor[] profileMonitorArray = monitors;
            int n = monitors.length;
            int n2 = 0;
            while (n2 < n) {
                ProfileMonitor profMon = profileMonitorArray[n2];
                writer.write(profMon.toCsvString());
                writer.newLine();
                ++n2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        LOG.info("Profiling data dumped to '{}'.", (Object)dumpFile);
    }

    @MayReturnNull
    public ProfileMonitor getProfileMonitor(Class<?> clazz, String method) {
        return this.getProfileMonitor(String.valueOf(clazz.getName()) + "." + method);
    }

    @MayReturnNull
    public ProfileMonitor getProfileMonitor(Signature signature) {
        return this.getProfileMonitor(SignatureHelper.getAsString(signature));
    }

    @MayReturnNull
    public ProfileMonitor getProfileMonitor(String signature) {
        ProfileMonitor[] profileMonitorArray = this.getMonitors();
        int n = profileMonitorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProfileMonitor profMon = profileMonitorArray[n2];
            if (signature.equals(profMon.getLabel())) {
                return profMon;
            }
            ++n2;
        }
        LOG.trace("no ProfileMonitor for " + signature + " found");
        return null;
    }

    @Override
    public String toString() {
        return this.mbeanName.toString();
    }
}

