/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor;

import java.io.File;
import java.io.IOException;
import javax.management.openmbean.TabularData;
import patterntesting.runtime.jmx.Description;
import patterntesting.runtime.jmx.Unit;

@Description(value="Profile statistic for different methods")
public interface ProfileStatisticMBean {
    @Description(value="reset the statistic to be ready for new measurement")
    public void reset();

    @Description(value="maximal number how often a method is called")
    public int getMaxHits();

    @Description(value="the name of the method which was called most")
    public String getMaxHitsLabel();

    @Description(value="statistic of the most called method")
    public String getMaxHitsStatistic();

    @Description(value="maximal total time of a method")
    @Unit(value="milliseconds")
    public double getMaxTotal();

    @Description(value="the name of the method which need most of the time")
    public String getMaxTotalLabel();

    @Description(value="statistic of the method which need most of the time")
    public String getMaxTotalStatistic();

    @Description(value="maximal average time")
    @Unit(value="milliseconds")
    public double getMaxAvg();

    @Description(value="the name of the method with the maximal average time")
    public String getMaxAvgLabel();

    @Description(value="statistic of the method with the maximal average time")
    public String getMaxAvgStatistic();

    @Description(value="maximal time of a method")
    @Unit(value="milliseconds")
    public double getMaxMax();

    @Description(value="the name of the method with the maximal time of a single run")
    public String getMaxMaxLabel();

    @Description(value="statistic of the method with the maximal time of a single run")
    public String getMaxMaxStatistic();

    @Description(value="set maximal number of statistic entries")
    public void setMaxSize(int var1);

    @Description(value="get maximal number of statistic entries")
    public int getMaxSize();

    @Description(value="the statistic table")
    public TabularData getStatistics();

    @Description(value="log the statistic data")
    public void logStatistic();

    @Description(value="dump the statistic data to a temporary file")
    public File dumpStatistic() throws IOException;

    @Description(value="dump the statistic data to a given file")
    public void dumpStatistic(String var1) throws IOException;
}

