/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import patterntesting.runtime.jmx.Description;
import patterntesting.runtime.monitor.AbstractMonitor;
import patterntesting.runtime.monitor.ResourcepathMonitorMBean;
import patterntesting.runtime.monitor.internal.DoubletDigger;
import patterntesting.runtime.monitor.internal.ResourceWalker;
import patterntesting.runtime.monitor.internal.ResourcepathDigger;
import patterntesting.runtime.util.ArchivEntry;

public class ResourcepathMonitor
extends AbstractMonitor
implements ResourcepathMonitorMBean {
    private static final Logger LOG = LogManager.getLogger(ResourcepathMonitor.class);
    private static final Executor EXECUTOR = Executors.newCachedThreadPool();
    private static final ResourcepathMonitor INSTANCE = new ResourcepathMonitor();
    private final ResourcepathDigger classpathDigger = new ResourcepathDigger();
    private final DoubletDigger doubletDigger = new DoubletDigger(this.classpathDigger);
    private final FutureTask<String[]> resources = this.getFutureResources();

    private ResourcepathMonitor() {
    }

    private FutureTask<String[]> getFutureResources() {
        Callable<String[]> callable = new Callable<String[]>(){

            @Override
            public String[] call() throws Exception {
                return ResourcepathMonitor.this.getResourcesArray();
            }
        };
        FutureTask<String[]> classes = new FutureTask<String[]>(callable);
        EXECUTOR.execute(classes);
        return classes;
    }

    public static ResourcepathMonitor getInstance() {
        return INSTANCE;
    }

    public static void registerAsMBean() {
        ResourcepathMonitor.getInstance().registerMeAsMBean();
    }

    public static void unregisterAsMBean() {
        ResourcepathMonitor.getInstance().unregisterMeAsMBean();
    }

    public static boolean isRegisteredAsMBean() {
        return ResourcepathMonitor.getInstance().isMBean();
    }

    @Override
    public String[] getResources() {
        try {
            return this.resources.get();
        }
        catch (ExecutionException ex) {
            LOG.warn("Cannot execute get of {}:", this.resources, (Object)ex);
        }
        catch (InterruptedException ex) {
            LOG.warn("Was interrupted before got result from {}:", this.resources, (Object)ex);
            Thread.currentThread().interrupt();
        }
        return this.getResourcesArray();
    }

    private String[] getResourcesArray() {
        Set<String> resourceSet = this.scanResources();
        return resourceSet.toArray(new String[resourceSet.size()]);
    }

    private Set<String> scanResources() {
        String[] classpathes;
        TreeSet<String> resourceSet = new TreeSet<String>();
        String[] stringArray = classpathes = this.classpathDigger.getClasspath();
        int n = classpathes.length;
        int n2 = 0;
        while (n2 < n) {
            String cp = stringArray[n2];
            try {
                resourceSet.addAll(ResourcepathMonitor.scanResources(cp));
            }
            catch (IOException ioe) {
                LOG.warn("Classpath '{}' is ignored:", (Throwable)ioe);
            }
            ++n2;
        }
        return resourceSet;
    }

    private static Set<String> scanResources(String classpath) throws IOException {
        File file = new File(classpath);
        if (file.isDirectory()) {
            return ResourcepathMonitor.scanResourcesFromDir(file);
        }
        return ResourcepathMonitor.scanResourcesFromJar(file);
    }

    private static Set<String> scanResourcesFromDir(File dir) throws IOException {
        LOG.trace("Resources are scanned from dir '{}'.", (Object)dir);
        ResourceWalker resourceWalker = new ResourceWalker(dir);
        return new TreeSet<String>(resourceWalker.getResources());
    }

    private static Set<String> scanResourcesFromJar(File file) throws IOException {
        LOG.trace("Resources are scanned from jar '{}'.", (Object)file);
        TreeSet<String> resources = new TreeSet<String>();
        JarFile jarFile = new JarFile(file);
        try {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String entryName = entries.nextElement().getName();
                if (StringUtils.endsWithIgnoreCase((CharSequence)entryName, (CharSequence)".class") || entryName.endsWith("/")) continue;
                resources.add("/" + entryName);
            }
            TreeSet<String> treeSet = resources;
            return treeSet;
        }
        finally {
            IOUtils.closeQuietly((Closeable)jarFile);
        }
    }

    @Override
    @Description(value="returns the URI of the given resource")
    public URI whichResource(String name) {
        return this.classpathDigger.whichResource(name);
    }

    public Enumeration<URL> getResourcesFor(String name) {
        return this.classpathDigger.getResources(name);
    }

    @Override
    public int getNoResources(String name) {
        Enumeration<URL> urls = this.getResourcesFor(name);
        if (urls == null) {
            return 0;
        }
        int n = 0;
        while (urls.hasMoreElements()) {
            ++n;
            urls.nextElement();
        }
        LOG.trace("{} element(s) of {} found in classpath.", (Object)n, (Object)name);
        return n;
    }

    @Override
    @Description(value="is the given classname or resource found more than once in the classpath?")
    public boolean isDoublet(String name) {
        return this.doubletDigger.isDoublet(name);
    }

    @Override
    @Description(value="returns the first doublet of the given classname or resource")
    public URI getFirstDoublet(String name) {
        return this.getDoublet(name, 1);
    }

    @Override
    public URI getDoublet(String name, int nr) {
        return this.doubletDigger.getDoublet(name, nr);
    }

    @Override
    public String[] getDoublets() {
        ArrayList<String> doublets = new ArrayList<String>();
        String[] stringArray = this.getResources();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String resource = stringArray[n2];
            try {
                if (!"/META-INF/MANIFEST.MF".equals(resource) && this.isDoublet(resource)) {
                    doublets.add(resource);
                }
            }
            catch (NoSuchElementException ex) {
                LOG.debug("'{}' is ignored as resource ({})", (Object)resource, (Object)ex.getMessage());
                LOG.trace("Details:", (Throwable)ex);
            }
            ++n2;
        }
        return doublets.toArray(new String[doublets.size()]);
    }

    @Override
    @Description(value="returns the classpath where doublets were found")
    public String[] getDoubletResourcepath() {
        URI[] resourcepathURIs = this.getDoubletResourcepathURIs();
        return ResourcepathMonitor.toStringArray(resourcepathURIs);
    }

    protected URI[] getDoubletResourcepathURIs() {
        LOG.trace("Calculating doublet-resourcepath.");
        ArrayList<String> doubletsWithoutMetaInf = new ArrayList<String>();
        String[] stringArray = this.getDoublets();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String doublet = stringArray[n2];
            if (!"/META-INF/MANIFEST.MF".equals(doublet)) {
                doubletsWithoutMetaInf.add(doublet);
            }
            ++n2;
        }
        SortedSet<URI> resourcepathSet = this.classpathDigger.getResourcepathSet(doubletsWithoutMetaInf);
        return resourcepathSet.toArray(new URI[resourcepathSet.size()]);
    }

    @Override
    public String[] getIncompatibleResources() {
        ArrayList<String> incompatibleResources = new ArrayList<String>();
        String[] stringArray = this.getDoublets();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String rsc = stringArray[n2];
            Enumeration<URL> doubletURLs = this.getResourcesFor(rsc);
            try {
                URL url = doubletURLs.nextElement();
                ArchivEntry archivEntry = new ArchivEntry(url);
                while (doubletURLs.hasMoreElements()) {
                    url = doubletURLs.nextElement();
                    ArchivEntry doubletEntry = new ArchivEntry(url);
                    if (!archivEntry.equals(doubletEntry)) continue;
                    incompatibleResources.add(rsc);
                    break;
                }
            }
            catch (NoSuchElementException nse) {
                LOG.warn("{} is not added to incompatible resource list:", (Object)rsc, (Object)nse);
            }
            ++n2;
        }
        return incompatibleResources.toArray(new String[incompatibleResources.size()]);
    }

    @Override
    public String[] getIncompatibleResourcepath() {
        URI[] resourcepathURIs = this.getIncompatibleResourcepathURIs();
        return ResourcepathMonitor.toStringArray(resourcepathURIs);
    }

    protected URI[] getIncompatibleResourcepathURIs() {
        ArrayList<String> resourcesWithoutMetainf = new ArrayList<String>();
        String[] stringArray = this.getIncompatibleResources();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String resource = stringArray[n2];
            if (!resource.startsWith("/META-INF")) {
                resourcesWithoutMetainf.add(resource);
            }
            ++n2;
        }
        SortedSet<URI> resourcepathSet = this.classpathDigger.getResourcepathSet(resourcesWithoutMetainf);
        return resourcepathSet.toArray(new URI[resourcepathSet.size()]);
    }

    @Override
    public void logMe() {
        try {
            StringWriter writer = new StringWriter();
            ResourcepathMonitor.dumpArray((Object[])this.getResources(), new BufferedWriter(writer), "resources");
            LOG.info(writer.toString());
        }
        catch (IOException cannothappen) {
            LOG.warn("Cannot dump resources:", (Throwable)cannothappen);
        }
    }

    @Override
    public void dumpMe(File dumpDir) throws IOException {
        this.dump(dumpDir, "DoubletResourcepath", "DoubletResourcepathURIs", "Doublets", "IncompatibleResources", "IncompatibleResourcepath", "IncompatibleResourcepathURIs", "Resources");
        this.copyResource("RscMonREADME.txt", new File(dumpDir, "README.txt"));
    }
}

