/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import patterntesting.runtime.monitor.ProfileMonitor;
import patterntesting.runtime.monitor.ProfileMonitorFactory;
import patterntesting.runtime.monitor.SimpleProfileMonitor;

public final class SimpleProfileMonitorFactory
extends ProfileMonitorFactory {
    private static final Logger LOG = LogManager.getLogger(SimpleProfileMonitorFactory.class);
    private int maxSize = Integer.MAX_VALUE;

    public SimpleProfileMonitorFactory(SimpleProfileMonitor rootMonitor) {
        super(rootMonitor);
    }

    @Override
    public ProfileMonitor[] getMonitors() {
        return this.rootMonitor.getMonitors();
    }

    @Override
    public ProfileMonitor getMonitor(String label) {
        SimpleProfileMonitor parent = this.getSimpleProfileMonitor(label);
        return new SimpleProfileMonitor(label, parent);
    }

    private SimpleProfileMonitor getSimpleProfileMonitor(String sig) {
        SimpleProfileMonitor monitor = this.rootMonitor.getMonitor(sig);
        if (monitor == null) {
            monitor = new SimpleProfileMonitor(sig, this.rootMonitor);
            int tooMuch = this.rootMonitor.getNumberOfMonitors() - this.maxSize;
            int i = 0;
            while (i < tooMuch) {
                ProfileMonitor[] monitors = this.rootMonitor.getMonitors();
                SimpleProfileMonitor oldest = SimpleProfileMonitorFactory.getOldestMonitorOf(monitors);
                this.removeMonitor(oldest);
                ++i;
            }
        }
        return monitor;
    }

    private void removeMonitor(SimpleProfileMonitor monitor) {
        this.rootMonitor.removeMonitor(monitor);
    }

    private static SimpleProfileMonitor getOldestMonitorOf(ProfileMonitor[] monitors) {
        ProfileMonitor oldest = monitors[0];
        int maxHits = oldest.getHits();
        double maxAvg = oldest.getAvg();
        double maxTotal = oldest.getTotal();
        double maxMax = oldest.getMax();
        int i = 1;
        while (i < monitors.length) {
            ProfileMonitor mon = monitors[i];
            if (mon == null) {
                LOG.info("Will return {} as oldest because monitor {} is null (lost?).", (Object)oldest, (Object)i);
                break;
            }
            if (oldest.getLastAccess().after(mon.getFirstAccess()) && mon.getHits() <= maxHits && mon.getAvg() <= maxAvg && mon.getTotal() <= maxTotal && mon.getMax() <= maxMax) {
                oldest = mon;
            } else {
                if (mon.getHits() > maxHits) {
                    maxHits = mon.getHits();
                }
                if (mon.getAvg() > maxAvg) {
                    maxAvg = mon.getAvg();
                }
                if (mon.getTotal() > maxTotal) {
                    maxTotal = mon.getTotal();
                }
                if (mon.getMax() > maxMax) {
                    maxMax = mon.getMax();
                }
            }
            ++i;
        }
        return (SimpleProfileMonitor)oldest;
    }

    @Override
    public int getMaxNumMonitors() {
        return this.maxSize;
    }

    @Override
    public void setMaxNumMonitors(int size) {
        this.maxSize = size;
        ProfileMonitor[] monitors = this.rootMonitor.getMonitors();
        int tooMuch = monitors.length - size;
        int i = 0;
        while (i < tooMuch) {
            SimpleProfileMonitor oldest = SimpleProfileMonitorFactory.getOldestMonitorOf(monitors);
            this.removeMonitor(oldest);
            monitors = this.rootMonitor.getMonitors();
            ++i;
        }
        LOG.debug("Max size is set to {}, actual size is {}.", (Object)size, (Object)monitors.length);
    }

    @Override
    public void reset() {
        this.rootMonitor.reset();
    }

    @Override
    public void addMonitors(List<String> labels) {
        this.rootMonitor.addChildren(labels);
    }
}

