/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor.db;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.JMException;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import patterntesting.runtime.jmx.MBeanHelper;
import patterntesting.runtime.monitor.AbstractMonitor;
import patterntesting.runtime.monitor.db.ConnectionMonitorMBean;
import patterntesting.runtime.monitor.db.ProxyConnection;

public class ConnectionMonitor
extends AbstractMonitor
implements ConnectionMonitorMBean {
    private static final Logger LOG = LogManager.getLogger(ConnectionMonitor.class);
    private static final ConnectionMonitor INSTANCE;
    private static final List<ProxyConnection> openConnections;
    private static int sumOfConnections;

    static {
        openConnections = new CopyOnWriteArrayList<ProxyConnection>();
        sumOfConnections = 0;
        INSTANCE = new ConnectionMonitor();
        try {
            MBeanHelper.registerMBean(INSTANCE);
            LOG.debug("{} created and registered as MBean.", (Object)INSTANCE);
        }
        catch (JMException e) {
            LOG.info("{} can't be registered as MBean ({})", (Object)INSTANCE, (Object)e);
        }
    }

    protected ConnectionMonitor() {
        LOG.trace("New instance of {} created.", ConnectionMonitor.class);
    }

    public static ConnectionMonitor getInstance() {
        return INSTANCE;
    }

    public static Connection getMonitoredConnection(Connection connection) {
        return ProxyConnection.newInstance(connection);
    }

    public static void addConnection(ProxyConnection proxyConnection) {
        openConnections.add(proxyConnection);
        ++sumOfConnections;
    }

    public static void removeConnection(ProxyConnection proxyConnection) {
        openConnections.remove(proxyConnection);
    }

    public static StackTraceElement getCallerOf(Connection connection) {
        for (ProxyConnection proxy : openConnections) {
            if (!proxy.getConnection().equals(connection)) continue;
            return proxy.getCaller()[0];
        }
        throw new IllegalArgumentException("not monitored or closed: " + connection);
    }

    @Override
    public StackTraceElement[] getCallers() {
        StackTraceElement[] callers = new StackTraceElement[openConnections.size()];
        int i = 0;
        for (ProxyConnection proxy : openConnections) {
            callers[i] = proxy.getCaller()[0];
            ++i;
        }
        return callers;
    }

    @Override
    public StackTraceElement[] getLastCallerStacktrace() {
        ProxyConnection lastConnection = openConnections.get(openConnections.size() - 1);
        return lastConnection.getCaller();
    }

    @Override
    public TabularData getCallerStacktraces() throws OpenDataException {
        String[] itemNames = new String[]{"Caller", "Stacktrace"};
        String[] itemDescriptions = new String[]{"caller name", "stacktrace"};
        try {
            OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, new ArrayType(1, SimpleType.STRING)};
            CompositeType rowType = new CompositeType("propertyType", "property entry", itemNames, itemDescriptions, itemTypes);
            TabularDataSupport data = MBeanHelper.createTabularDataSupport(rowType, itemNames);
            for (ProxyConnection proxy : openConnections) {
                StackTraceElement[] stacktrace = proxy.getCaller();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("Caller", stacktrace[0].toString());
                map.put("Stacktrace", ConnectionMonitor.toStringArray(stacktrace));
                CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
                data.put(compData);
            }
            return data;
        }
        catch (OpenDataException ex) {
            LOG.warn("Cannot get caller stacktraces of " + openConnections.size() + " open connections.", (Throwable)ex);
            throw ex;
        }
    }

    private static String[] toStringArray(StackTraceElement[] stacktrace) {
        String[] array = new String[stacktrace.length];
        int i = 0;
        while (i < stacktrace.length) {
            array[i] = stacktrace[i].toString();
            ++i;
        }
        return array;
    }

    @Override
    public StackTraceElement getLastCaller() {
        StackTraceElement[] callers = this.getCallers();
        if (callers.length == 0) {
            LOG.debug("No open connections - last caller is null.");
            return null;
        }
        return callers[callers.length - 1];
    }

    @Override
    public int getOpenConnections() {
        return openConnections.size();
    }

    @Override
    public int getClosedConnections() {
        return this.getSumOfConnections() - this.getOpenConnections();
    }

    @Override
    public int getSumOfConnections() {
        return sumOfConnections;
    }

    public static void assertConnectionsClosed() {
        int count = INSTANCE.getOpenConnections();
        if (count > 0) {
            AssertionError error = new AssertionError((Object)(String.valueOf(count) + " connection(s) not closed"));
            ((Throwable)((Object)error)).setStackTrace(openConnections.iterator().next().getCaller());
            throw error;
        }
    }

    @Override
    public String toString() {
        int n = this.getOpenConnections();
        if (n < 1) {
            return this.getClass().getSimpleName();
        }
        return String.valueOf(this.getClass().getSimpleName()) + " watching " + n + " connection(s)";
    }

    @Override
    public void dumpMe(File dumpDir) throws IOException {
        super.dumpMe(dumpDir);
        ConnectionMonitor.dumpArray((Object[])this.getCallers(), dumpDir, "callers");
        ConnectionMonitor.dumpArray((Object[])this.getLastCallerStacktrace(), dumpDir, "lastCallerStracktrace");
        ConnectionMonitor.dumpArray(openConnections.toArray(), dumpDir, "openConnections");
        ConnectionMonitor.dumpArray(ConnectionMonitor.getCallerStacktraceDumps().toArray(), dumpDir, "callerStacktraces");
    }

    @Override
    public void logMe() {
        try {
            StringWriter writer = new StringWriter();
            ConnectionMonitor.dumpArray((Object[])this.getCallers(), new BufferedWriter(writer), "callers");
            ConnectionMonitor.dumpArray((Object[])this.getLastCallerStacktrace(), new BufferedWriter(writer), "lastCallerStracktrace");
            ConnectionMonitor.dumpArray(openConnections.toArray(), new BufferedWriter(writer), "openConnections");
            ConnectionMonitor.dumpArray(ConnectionMonitor.getCallerStacktraceDumps().toArray(), new BufferedWriter(writer), "callerStacktraces");
            LOG.info(writer.toString());
        }
        catch (IOException cannothappen) {
            LOG.warn("Cannot dump resources:", (Throwable)cannothappen);
        }
    }

    @Override
    public void logCallerStacktraces() {
        for (String dump : ConnectionMonitor.getCallerStacktraceDumps()) {
            LOG.info(dump);
        }
    }

    private static List<String> getCallerStacktraceDumps() {
        ArrayList<String> connectionStacktraces = new ArrayList<String>();
        for (ProxyConnection proxy : openConnections) {
            StackTraceElement[] stacktrace;
            StringBuilder buf = new StringBuilder();
            StackTraceElement[] stackTraceElementArray = stacktrace = proxy.getCaller();
            int n = stacktrace.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement element = stackTraceElementArray[n2];
                buf.append("\n\tat ");
                buf.append(element);
                ++n2;
            }
            connectionStacktraces.add(proxy + " was called " + buf);
        }
        return connectionStacktraces;
    }

    @Override
    public void run() {
        super.run();
        LOG.info("---->>>>---->>>>----    {} of {} connection(s) are still open    ---->>>>---->>>>----", (Object)openConnections.size(), (Object)sumOfConnections);
        this.logCallerStacktraces();
        LOG.info("----<<<<----<<<<----    {} of {} connection(s) are still open    ----<<<<----<<<<----", (Object)openConnections.size(), (Object)sumOfConnections);
    }
}

