/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor.db;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import patterntesting.runtime.annotation.IgnoreForSequenceDiagram;
import patterntesting.runtime.monitor.db.ConnectionMonitor;
import patterntesting.runtime.monitor.db.ProxyDriver;
import patterntesting.runtime.monitor.db.internal.StasiPreparedStatement;
import patterntesting.runtime.monitor.db.internal.StasiStatement;

@IgnoreForSequenceDiagram
public class ProxyConnection
implements InvocationHandler {
    private static final Logger LOG = LogManager.getLogger(ProxyConnection.class);
    private final Connection connection;
    private final StackTraceElement[] caller;
    private final Collection<StasiStatement> uncommittedStatements = new CopyOnWriteArrayList<StasiStatement>();
    private boolean committed = false;
    private boolean autoCommit = true;

    public static Connection newInstance(Connection connection) {
        ProxyConnection proxyConnection = new ProxyConnection(connection);
        ConnectionMonitor.addConnection(proxyConnection);
        Class[] interfaces = new Class[]{Connection.class};
        return (Connection)Proxy.newProxyInstance(connection.getClass().getClassLoader(), interfaces, (InvocationHandler)proxyConnection);
    }

    protected ProxyConnection(Connection connection) {
        this.connection = connection;
        this.caller = StasiStatement.getCallerStacktrace(ProxyConnection.class, ProxyDriver.class, ConnectionMonitor.class, DriverManager.class);
        try {
            this.autoCommit = connection.getAutoCommit();
        }
        catch (SQLException sex) {
            LOG.debug("Cannot decide if auto-commit is on:", (Throwable)sex);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        LOG.trace("Call of {} is delegated to {}.", proxy, (Object)this.connection);
        String methodName = method.getName();
        try {
            if ("createStatement".equals(methodName)) {
                Statement stmt = (Statement)method.invoke((Object)this.connection, args);
                return this.save(new StasiStatement(stmt));
            }
            if ("prepareStatement".equals(methodName)) {
                PreparedStatement stmt = (PreparedStatement)method.invoke((Object)this.connection, args);
                return this.save(new StasiPreparedStatement(stmt, args));
            }
            if ("toString".equals(methodName)) {
                return this.toString();
            }
            return this.invoke(method, args);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getTargetException();
            LOG.trace("Cannot invoke {}:", (Object)method, (Object)ex);
            throw cause;
        }
    }

    private Object invoke(Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("close".equals(methodName)) {
            this.close();
        } else if ("setAutoCommit".equals(methodName)) {
            this.autoCommit = (Boolean)args[0];
        } else if (this.isCommitMethod(methodName)) {
            this.commit();
        }
        return method.invoke((Object)this.connection, args);
    }

    private void commit() {
        this.committed = true;
        this.uncommittedStatements.clear();
    }

    private boolean isCommitMethod(String methodName) {
        return "commit".equals(methodName) || "rollback".equals(methodName);
    }

    private void close() {
        ConnectionMonitor.removeConnection(this);
        for (StasiStatement stmt : this.uncommittedStatements) {
            int updateCount = stmt.getUpdateCount();
            if (updateCount <= 0 || this.isCommitted()) continue;
            LOG.warn("{} entries were updated with '{}' but not committed.", (Object)updateCount, (Object)stmt);
        }
        LOG.trace("'{}' is closed, {} statement(s) will be freed.", (Object)this, (Object)this.uncommittedStatements.size());
        this.uncommittedStatements.clear();
    }

    private Statement save(StasiStatement stmt) {
        if (!this.autoCommit) {
            this.uncommittedStatements.add(stmt);
            LOG.trace("{} is added to {}.", (Object)stmt, (Object)this);
        }
        return stmt;
    }

    private boolean isCommitted() {
        return this.autoCommit || this.committed;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public StackTraceElement[] getCaller() {
        return this.caller;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " for " + this.caller[0];
    }
}

