/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor.db;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import patterntesting.runtime.monitor.db.ProxyConnection;

public class ProxyDriver
implements Driver {
    private static final String JDBC_URL_PREFIX = "jdbc:proxy:";
    private static final org.apache.logging.log4j.Logger LOG = LogManager.getLogger(ProxyDriver.class);
    private static final Map<String, String> KNOWN_DRIVERS = new HashMap<String, String>();

    static {
        ProxyDriver.register();
        KNOWN_DRIVERS.put("hsqldb", "org.hsqldb.jdbc.JDBCDriver");
        KNOWN_DRIVERS.put("informix-sqli", "com.informix.jdbc.IfxDriver");
        KNOWN_DRIVERS.put("jturbo", "com.newatlanta.jturbo.driver.Driver");
        KNOWN_DRIVERS.put("sqlserver", "com.microsoft.sqlserver.jdbc.SQLServerDriver");
    }

    private static String getKnownDriverFor(String jdbcURL) {
        String[] parts = StringUtils.split((String)(String.valueOf(jdbcURL) + ":x"), (char)':');
        return KNOWN_DRIVERS.get(parts[1].toLowerCase());
    }

    public static void register() {
        ProxyDriver driver = new ProxyDriver();
        try {
            Set<Driver> deregistered = ProxyDriver.deregisterDrivers();
            DriverManager.registerDriver(driver);
            ProxyDriver.registerDrivers(deregistered);
            LOG.debug("{} successful registered as JDBC driver.", (Object)driver);
        }
        catch (SQLException ex) {
            DriverManager.println("Cannot register " + driver + " because of " + ex.getMessage() + ".");
            LOG.error("Cannot register {} as JDBC driver.", (Object)driver, (Object)ex);
        }
    }

    private static Set<Driver> deregisterDrivers() {
        HashSet<Driver> deregistered = new HashSet<Driver>();
        Enumeration<Driver> registered = DriverManager.getDrivers();
        while (registered.hasMoreElements()) {
            deregistered.add(registered.nextElement());
        }
        for (Driver driver : deregistered) {
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException sex) {
                LOG.debug("Cannot deregister {} from DriverManager.", (Object)driver);
                LOG.trace("Details: ", (Throwable)sex);
                deregistered.remove(driver);
            }
        }
        LOG.trace("{} driver(s) deregistered.", (Object)deregistered.size());
        return deregistered;
    }

    private static void registerDrivers(Set<Driver> deregistered) {
        for (Driver driver : deregistered) {
            try {
                DriverManager.registerDriver(driver);
            }
            catch (SQLException sex) {
                LOG.warn("Cannot register {} again:", (Object)driver, (Object)sex);
            }
        }
    }

    public static String getRealURL(String jdbcURL) {
        if (jdbcURL.startsWith(JDBC_URL_PREFIX)) {
            return "jdbc:" + StringUtils.substring((String)jdbcURL, (int)JDBC_URL_PREFIX.length());
        }
        return jdbcURL;
    }

    public static String getRealDriverName(String jdbcURL) {
        return ProxyDriver.getDriverName(ProxyDriver.getRealURL(jdbcURL));
    }

    private static String getDriverName(String jdbcURL) {
        String driverName = ProxyDriver.getKnownDriverFor(jdbcURL);
        if (driverName == null) {
            return ProxyDriver.getDriver(jdbcURL).getClass().getName();
        }
        return driverName;
    }

    public static Driver getRealDriver(String jdbcURL) {
        String realURL = ProxyDriver.getRealURL(jdbcURL);
        return ProxyDriver.getDriver(realURL);
    }

    private static Driver getDriver(String url) {
        try {
            return DriverManager.getDriver(url);
        }
        catch (SQLException ex) {
            LOG.trace("Cannot get driver from DriverManager.", (Throwable)ex);
            LOG.debug("Must first load driver for \"{}\" because {}.", (Object)url, (Object)ex.getMessage());
            return ProxyDriver.loadDriverFor(url);
        }
    }

    private static Driver loadDriverFor(String jdbcURL) {
        String driverName = ProxyDriver.getKnownDriverFor(jdbcURL);
        try {
            if (driverName != null) {
                Class<?> driverClass = Class.forName(driverName);
                LOG.debug("Driver {} for URL \"{}\" loaded.", (Object)driverName, (Object)jdbcURL);
                Driver driver = (Driver)driverClass.newInstance();
                DriverManager.registerDriver(driver);
                LOG.debug("Driver {} for URL \"{}\" registered.", (Object)driver, (Object)jdbcURL);
            }
            return DriverManager.getDriver(jdbcURL);
        }
        catch (SQLException ex) {
            throw new IllegalArgumentException("unregistered URL: \"" + jdbcURL + '\"', ex);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("cannot load driver for \"" + jdbcURL + '\"', ex);
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalArgumentException("driver '" + driverName + "' for URL \"{}\" loaded but registration failed", ex);
        }
    }

    @Override
    public boolean acceptsURL(String url) {
        String prefix = url.toLowerCase();
        return StringUtils.startsWith((CharSequence)prefix, (CharSequence)JDBC_URL_PREFIX);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        LOG.trace("Connecting to URL \"{}\"...", (Object)url);
        if (!this.acceptsURL(url)) {
            LOG.trace("{} does not accept \"{}\" as URL.", (Object)this, (Object)url);
            return null;
        }
        String realURL = ProxyDriver.getRealURL(url);
        Driver realDriver = ProxyDriver.getDriver(realURL);
        Connection connection = realDriver.connect(realURL, info);
        LOG.trace("Connected to real URL \"{}\".", (Object)realURL);
        return ProxyConnection.newInstance(connection);
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 4;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        String realURL = ProxyDriver.getRealURL(url);
        Driver driver = ProxyDriver.getDriver(realURL);
        return driver.getPropertyInfo(realURL, info);
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("not yet implemented");
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.getMajorVersion() + "." + this.getMinorVersion() + " for \"" + JDBC_URL_PREFIX + "...\"";
    }
}

