/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor.db;

import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import patterntesting.runtime.monitor.ProfileMonitor;
import patterntesting.runtime.monitor.ProfileStatistic;
import patterntesting.runtime.monitor.db.SqlStatisticMBean;
import patterntesting.runtime.monitor.db.internal.StasiPreparedStatement;
import patterntesting.runtime.monitor.db.internal.StasiStatement;
import patterntesting.runtime.util.Converter;
import patterntesting.runtime.util.StackTraceScanner;

public class SqlStatistic
extends ProfileStatistic
implements SqlStatisticMBean {
    private static final Logger LOG = LogManager.getLogger(SqlStatistic.class);
    private static final SqlStatistic SQL_INSTANCE = new SqlStatistic();

    public static SqlStatistic getInstance() {
        return SQL_INSTANCE;
    }

    private SqlStatistic() {
        super("SQL");
    }

    public static void registerAsMBean(String name) {
        SQL_INSTANCE.registerMeAsMBean(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Class<SqlStatistic> clazz = SqlStatistic.class;
        synchronized (SqlStatistic.class) {
            this.resetRootMonitor();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static ProfileMonitor start(String sql) {
        return SQL_INSTANCE.startProfileMonitorFor(sql.trim());
    }

    public static void stop(ProfileMonitor mon, String command) {
        SqlStatistic.stop(mon, command, Void.TYPE);
    }

    public static void stop(ProfileMonitor mon, String command, Object returnValue) {
        mon.stop();
        if (LOG.isDebugEnabled()) {
            String msg = String.valueOf('\"') + command + "\" returned with " + Converter.toShortString(returnValue) + " after " + mon.getLastTime();
            if (LOG.isTraceEnabled()) {
                StackTraceElement[] stacktrace = StackTraceScanner.getCallerStackTrace(new Pattern[0], SqlStatistic.class, StasiStatement.class, StasiPreparedStatement.class);
                LOG.trace("{}\n\t{}", (Object)msg, (Object)Converter.toLongString(stacktrace).trim());
            } else {
                LOG.debug("{}.", (Object)msg);
            }
        }
    }

    public static void addAsShutdownHook() {
        SqlStatistic.addAsShutdownHook(SQL_INSTANCE);
    }

    public static /* bridge */ /* synthetic */ ProfileStatistic getInstance() {
        return SqlStatistic.getInstance();
    }
}

