/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor.db.internal;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import patterntesting.runtime.log.LogWatch;
import patterntesting.runtime.monitor.ProfileMonitor;
import patterntesting.runtime.monitor.db.SqlStatistic;
import patterntesting.runtime.monitor.db.internal.StasiResultSet;
import patterntesting.runtime.monitor.db.internal.StasiStatement;

public final class StasiPreparedStatement
extends StasiStatement
implements PreparedStatement {
    private static final Logger LOG = LogManager.getLogger(StasiPreparedStatement.class);
    private final LogWatch logWatch = new LogWatch();
    private final PreparedStatement preparedStatement;
    private final String sqlTemplate;
    private final Map<Integer, Object> parameters = new HashMap<Integer, Object>();

    public StasiPreparedStatement(PreparedStatement statement, Object ... args) {
        super(statement);
        this.preparedStatement = statement;
        this.sqlTemplate = (String)args[0];
    }

    public PreparedStatement getWrappedPreparedStatement() {
        return this.preparedStatement;
    }

    @Override
    public void addBatch() throws SQLException {
        this.preparedStatement.addBatch();
        LOG.trace("Batch added.");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.preparedStatement.clearParameters();
        this.parameters.clear();
        LOG.trace("Parameters cleared.");
    }

    @Override
    public void close() throws SQLException {
        this.getStatement().close();
        LOG.debug("Statement for \"{}\" was closed after {}.", (Object)this.sqlTemplate, (Object)this.logWatch);
    }

    @Override
    public boolean execute() throws SQLException {
        ProfileMonitor mon = SqlStatistic.start(this.sqlTemplate);
        try {
            boolean ok = this.preparedStatement.execute();
            SqlStatistic.stop(mon, this.getSQL4Logging(), ok);
            return ok;
        }
        catch (SQLException ex) {
            throw this.enrichedSQLException(mon, ex);
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        ProfileMonitor mon = SqlStatistic.start(this.sqlTemplate);
        try {
            StasiResultSet rs = new StasiResultSet(this.preparedStatement.executeQuery());
            SqlStatistic.stop(mon, this.getSQL4Logging(), rs);
            return rs;
        }
        catch (SQLException ex) {
            throw this.enrichedSQLException(mon, ex);
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        ProfileMonitor mon = SqlStatistic.start(this.sqlTemplate);
        try {
            int ret = this.preparedStatement.executeUpdate();
            this.saveUpdateStatistic(mon, this.getSQL4Logging(), ret);
            return ret;
        }
        catch (SQLException ex) {
            throw this.enrichedSQLException(mon, ex);
        }
    }

    private SQLException enrichedSQLException(ProfileMonitor mon, SQLException original) {
        return this.enrichedSQLException(mon, this.resolveSQL(), original);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.preparedStatement.getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.preparedStatement.getParameterMetaData();
    }

    @Override
    public void setArray(int arg0, Array arg1) throws SQLException {
        this.preparedStatement.setArray(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        this.preparedStatement.setAsciiStream(arg0, arg1, arg2);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        this.preparedStatement.setAsciiStream(arg0, arg1, arg2);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1) throws SQLException {
        this.preparedStatement.setAsciiStream(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        this.preparedStatement.setBigDecimal(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        this.preparedStatement.setBinaryStream(arg0, arg1, arg2);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        this.preparedStatement.setBinaryStream(arg0, arg1, arg2);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1) throws SQLException {
        this.preparedStatement.setBinaryStream(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setBlob(int arg0, Blob arg1) throws SQLException {
        this.preparedStatement.setBlob(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setBlob(int arg0, InputStream arg1, long arg2) throws SQLException {
        this.preparedStatement.setBlob(arg0, arg1, arg2);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setBlob(int arg0, InputStream arg1) throws SQLException {
        this.preparedStatement.setBlob(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setBoolean(int arg0, boolean arg1) throws SQLException {
        this.preparedStatement.setBoolean(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setByte(int arg0, byte arg1) throws SQLException {
        this.preparedStatement.setByte(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setBytes(int arg0, byte[] arg1) throws SQLException {
        this.preparedStatement.setBytes(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
        this.preparedStatement.setCharacterStream(arg0, arg1, arg2);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
        this.preparedStatement.setCharacterStream(arg0, arg1, arg2);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1) throws SQLException {
        this.preparedStatement.setCharacterStream(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setClob(int arg0, Clob arg1) throws SQLException {
        this.preparedStatement.setClob(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setClob(int arg0, Reader arg1, long arg2) throws SQLException {
        this.preparedStatement.setClob(arg0, arg1, arg2);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setClob(int arg0, Reader arg1) throws SQLException {
        this.preparedStatement.setClob(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setDate(int arg0, Date arg1, Calendar arg2) throws SQLException {
        this.preparedStatement.setDate(arg0, arg1, arg2);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setDate(int arg0, Date arg1) throws SQLException {
        this.preparedStatement.setDate(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setDouble(int arg0, double arg1) throws SQLException {
        this.preparedStatement.setDouble(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setFloat(int arg0, float arg1) throws SQLException {
        this.preparedStatement.setFloat(arg0, arg1);
        this.parameters.put(arg0, Float.valueOf(arg1));
    }

    @Override
    public void setInt(int arg0, int arg1) throws SQLException {
        this.preparedStatement.setInt(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setLong(int arg0, long arg1) throws SQLException {
        this.preparedStatement.setLong(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setNCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
        this.preparedStatement.setNCharacterStream(arg0, arg1, arg2);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setNCharacterStream(int arg0, Reader arg1) throws SQLException {
        this.preparedStatement.setNCharacterStream(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setNClob(int arg0, NClob arg1) throws SQLException {
        this.preparedStatement.setNClob(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setNClob(int arg0, Reader arg1, long arg2) throws SQLException {
        this.preparedStatement.setNClob(arg0, arg1, arg2);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setNClob(int arg0, Reader arg1) throws SQLException {
        this.preparedStatement.setNClob(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setNString(int arg0, String arg1) throws SQLException {
        this.preparedStatement.setNString(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setNull(int arg0, int arg1, String arg2) throws SQLException {
        this.preparedStatement.setNull(arg0, arg1, arg2);
        this.parameters.put(arg0, "'null'");
    }

    @Override
    public void setNull(int arg0, int arg1) throws SQLException {
        this.preparedStatement.setNull(arg0, arg1);
        this.parameters.put(arg0, "'null'");
    }

    @Override
    public void setObject(int arg0, Object arg1, int arg2, int arg3) throws SQLException {
        this.preparedStatement.setObject(arg0, arg1, arg2, arg3);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setObject(int arg0, Object arg1, int arg2) throws SQLException {
        this.preparedStatement.setObject(arg0, arg1, arg2);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setObject(int arg0, Object arg1) throws SQLException {
        this.preparedStatement.setObject(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setRef(int arg0, Ref arg1) throws SQLException {
        this.preparedStatement.setRef(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setRowId(int arg0, RowId arg1) throws SQLException {
        this.preparedStatement.setRowId(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setSQLXML(int arg0, SQLXML arg1) throws SQLException {
        this.preparedStatement.setSQLXML(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setShort(int arg0, short arg1) throws SQLException {
        this.preparedStatement.setShort(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setString(int arg0, String arg1) throws SQLException {
        this.preparedStatement.setString(arg0, arg1);
        this.parameters.put(arg0, "'" + arg1 + "'");
    }

    @Override
    public void setTime(int arg0, Time arg1, Calendar arg2) throws SQLException {
        this.preparedStatement.setTime(arg0, arg1, arg2);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setTime(int arg0, Time arg1) throws SQLException {
        this.preparedStatement.setTime(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setTimestamp(int arg0, Timestamp arg1, Calendar arg2) throws SQLException {
        this.preparedStatement.setTimestamp(arg0, arg1, arg2);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setTimestamp(int arg0, Timestamp arg1) throws SQLException {
        this.preparedStatement.setTimestamp(arg0, arg1);
        this.parameters.put(arg0, arg1);
    }

    @Override
    public void setURL(int arg0, URL arg1) throws SQLException {
        this.preparedStatement.setURL(arg0, arg1);
    }

    @Override
    public void setUnicodeStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        this.preparedStatement.setUnicodeStream(arg0, arg1, arg2);
    }

    @Override
    public String toString() {
        return this.resolveSQL();
    }

    private String resolveSQL() {
        String[] elements = StringUtils.split((String)(String.valueOf(this.sqlTemplate) + " "), (char)'?');
        StringBuilder buf = new StringBuilder(elements[0]);
        int i = 1;
        while (i < elements.length) {
            buf.append(this.getSqlParameter(i));
            buf.append(elements[i]);
            ++i;
        }
        return buf.toString().trim();
    }

    private Object getSqlParameter(int n) {
        Object param = this.parameters.get(n);
        if (param == null) {
            return Character.valueOf('?');
        }
        return param;
    }

    private String getSQL4Logging() {
        if (LogManager.getLogger(SqlStatistic.class).isDebugEnabled()) {
            return this.resolveSQL();
        }
        return this.sqlTemplate;
    }
}

