/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor.db.internal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import patterntesting.runtime.log.LogWatch;
import patterntesting.runtime.monitor.ProfileMonitor;
import patterntesting.runtime.monitor.db.ProxyConnection;
import patterntesting.runtime.monitor.db.SqlStatistic;
import patterntesting.runtime.monitor.db.internal.StasiResultSet;
import patterntesting.runtime.util.Converter;

public class StasiStatement
implements Statement {
    private static final Logger LOG = LogManager.getLogger(StasiStatement.class);
    private final LogWatch logWatch = new LogWatch();
    private final Statement statement;
    private final StackTraceElement[] caller;
    private int updateCount = 0;

    public StasiStatement(Statement statement) {
        this.statement = statement;
        this.caller = StasiStatement.getCallerStacktrace(ProxyConnection.class);
    }

    public static StackTraceElement[] getCallerStacktrace(Class<?> ... ignoredClasses) {
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        int i = 3;
        while (i < stacktrace.length) {
            String classname = stacktrace[i].getClassName();
            if (!classname.startsWith("com.sun.proxy.") && !StasiStatement.matches(classname, ignoredClasses)) {
                StackTraceElement[] stacktraceCaller = new StackTraceElement[stacktrace.length - i];
                System.arraycopy(stacktrace, i, stacktraceCaller, 0, stacktrace.length - i);
                return stacktraceCaller;
            }
            ++i;
        }
        throw new IllegalStateException("no caller found for " + Converter.toString(ignoredClasses));
    }

    private static boolean matches(String classname, Class<?> ... classes) {
        int i = 0;
        while (i < classes.length) {
            if (classname.equals(classes[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getUpdated() {
        return this.updateCount;
    }

    @Deprecated
    public Statement getWrappedStatement() {
        return this.statement;
    }

    protected final Statement getStatement() {
        return this.statement;
    }

    @Override
    public final void addBatch(String sql) throws SQLException {
        ProfileMonitor mon = SqlStatistic.start(sql);
        try {
            this.statement.addBatch(sql);
            SqlStatistic.stop(mon, sql);
        }
        catch (SQLException ex) {
            throw this.enrichedSQLException(mon, sql, ex);
        }
    }

    @Override
    public final void cancel() throws SQLException {
        this.statement.cancel();
        LOG.trace("{} cancelled.", (Object)this.statement);
    }

    @Override
    public final void clearBatch() throws SQLException {
        this.statement.clearBatch();
        LOG.trace("Batch cleared.");
    }

    @Override
    public final void clearWarnings() throws SQLException {
        this.statement.clearWarnings();
        LOG.trace("Warnings cleared.");
    }

    @Override
    public void close() throws SQLException {
        this.statement.close();
        LOG.debug("Statement {} was closed after {}.", (Object)this.statement, (Object)this.logWatch);
    }

    @Override
    public final boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        ProfileMonitor mon = SqlStatistic.start(sql);
        try {
            boolean ok = this.statement.execute(sql, autoGeneratedKeys);
            SqlStatistic.stop(mon, sql, ok);
            return ok;
        }
        catch (SQLException ex) {
            throw this.enrichedSQLException(mon, sql, ex);
        }
    }

    @Override
    public final boolean execute(String sql, int[] columnIndexes) throws SQLException {
        ProfileMonitor mon = SqlStatistic.start(sql);
        try {
            boolean ok = this.statement.execute(sql, columnIndexes);
            SqlStatistic.stop(mon, sql, ok);
            return ok;
        }
        catch (SQLException ex) {
            throw this.enrichedSQLException(mon, sql, ex);
        }
    }

    @Override
    public final boolean execute(String sql, String[] columnNames) throws SQLException {
        ProfileMonitor mon = SqlStatistic.start(sql);
        try {
            boolean ok = this.statement.execute(sql, columnNames);
            SqlStatistic.stop(mon, sql, ok);
            return ok;
        }
        catch (SQLException ex) {
            throw this.enrichedSQLException(mon, sql, ex);
        }
    }

    @Override
    public final boolean execute(String sql) throws SQLException {
        ProfileMonitor mon = SqlStatistic.start(sql);
        try {
            boolean ok = this.statement.execute(sql);
            SqlStatistic.stop(mon, sql, ok);
            return ok;
        }
        catch (SQLException ex) {
            throw this.enrichedSQLException(mon, sql, ex);
        }
    }

    @Override
    public final int[] executeBatch() throws SQLException {
        LogWatch watch = new LogWatch();
        int[] ret = this.statement.executeBatch();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Batch execution returns with {} after {}.", (Object)Converter.toString((Object)ret), (Object)watch);
        }
        return ret;
    }

    @Override
    public final ResultSet executeQuery(String sql) throws SQLException {
        ProfileMonitor mon = SqlStatistic.start(sql);
        try {
            StasiResultSet rs = new StasiResultSet(this.statement.executeQuery(sql));
            SqlStatistic.stop(mon, sql, rs);
            return rs;
        }
        catch (SQLException ex) {
            throw this.enrichedSQLException(mon, sql, ex);
        }
    }

    @Override
    public final int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        ProfileMonitor mon = SqlStatistic.start(sql);
        try {
            int ret = this.statement.executeUpdate(sql, autoGeneratedKeys);
            return this.saveUpdateStatistic(mon, sql, ret);
        }
        catch (SQLException ex) {
            throw this.enrichedSQLException(mon, sql, ex);
        }
    }

    @Override
    public final int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        ProfileMonitor mon = SqlStatistic.start(sql);
        try {
            int ret = this.statement.executeUpdate(sql, columnIndexes);
            return this.saveUpdateStatistic(mon, sql, ret);
        }
        catch (SQLException ex) {
            throw this.enrichedSQLException(mon, sql, ex);
        }
    }

    @Override
    public final int executeUpdate(String sql, String[] columnNames) throws SQLException {
        ProfileMonitor mon = SqlStatistic.start(sql);
        try {
            int ret = this.statement.executeUpdate(sql, columnNames);
            return this.saveUpdateStatistic(mon, sql, ret);
        }
        catch (SQLException ex) {
            throw this.enrichedSQLException(mon, sql, ex);
        }
    }

    @Override
    public final int executeUpdate(String sql) throws SQLException {
        ProfileMonitor mon = SqlStatistic.start(sql);
        try {
            int ret = this.statement.executeUpdate(sql);
            return this.saveUpdateStatistic(mon, sql, ret);
        }
        catch (SQLException ex) {
            throw this.enrichedSQLException(mon, sql, ex);
        }
    }

    protected int saveUpdateStatistic(ProfileMonitor mon, String sql, int rc) {
        SqlStatistic.stop(mon, sql, rc);
        this.updateCount += rc;
        return rc;
    }

    protected SQLException enrichedSQLException(ProfileMonitor mon, String sql, SQLException original) {
        mon.stop();
        return new SQLException("SQL \"" + sql + "\" failed after " + mon.getLastTime(), original);
    }

    @Override
    public final Connection getConnection() throws SQLException {
        return this.statement.getConnection();
    }

    @Override
    public final int getFetchDirection() throws SQLException {
        return this.statement.getFetchDirection();
    }

    @Override
    public final int getFetchSize() throws SQLException {
        return this.statement.getFetchSize();
    }

    @Override
    public final ResultSet getGeneratedKeys() throws SQLException {
        return new StasiResultSet(this.statement.getGeneratedKeys());
    }

    @Override
    public final int getMaxFieldSize() throws SQLException {
        return this.statement.getMaxFieldSize();
    }

    @Override
    public final int getMaxRows() throws SQLException {
        return this.statement.getMaxRows();
    }

    @Override
    public final boolean getMoreResults() throws SQLException {
        return this.statement.getMoreResults();
    }

    @Override
    public final boolean getMoreResults(int current) throws SQLException {
        return this.statement.getMoreResults(current);
    }

    @Override
    public final int getQueryTimeout() throws SQLException {
        return this.statement.getQueryTimeout();
    }

    @Override
    public final ResultSet getResultSet() throws SQLException {
        return new StasiResultSet(this.statement.getResultSet());
    }

    @Override
    public final int getResultSetConcurrency() throws SQLException {
        return this.statement.getResultSetConcurrency();
    }

    @Override
    public final int getResultSetHoldability() throws SQLException {
        return this.statement.getResultSetHoldability();
    }

    @Override
    public final int getResultSetType() throws SQLException {
        return this.statement.getResultSetType();
    }

    @Override
    public final int getUpdateCount() {
        try {
            return this.statement.getUpdateCount();
        }
        catch (SQLException sex) {
            LOG.debug("Returning {} as update count because original call failed ({}).", (Object)this.updateCount, (Object)sex.getMessage());
            LOG.trace("Details:", (Throwable)sex);
            return this.updateCount;
        }
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        return this.statement.getWarnings();
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.statement.isClosed();
    }

    @Override
    public final boolean isPoolable() throws SQLException {
        return this.statement.isPoolable();
    }

    @Override
    public final boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return this.statement.isWrapperFor(arg0);
    }

    @Override
    public final void setCursorName(String name) throws SQLException {
        this.statement.setCursorName(name);
    }

    @Override
    public final void setEscapeProcessing(boolean enable) throws SQLException {
        this.statement.setEscapeProcessing(enable);
    }

    @Override
    public final void setFetchDirection(int direction) throws SQLException {
        this.statement.setFetchDirection(direction);
    }

    @Override
    public final void setFetchSize(int rows) throws SQLException {
        this.statement.setFetchSize(rows);
    }

    @Override
    public final void setMaxFieldSize(int max) throws SQLException {
        this.statement.setMaxFieldSize(max);
    }

    @Override
    public final void setMaxRows(int max) throws SQLException {
        this.statement.setMaxRows(max);
    }

    @Override
    public final void setPoolable(boolean poolable) throws SQLException {
        this.statement.setPoolable(poolable);
    }

    @Override
    public final void setQueryTimeout(int seconds) throws SQLException {
        this.statement.setQueryTimeout(seconds);
    }

    @Override
    public final <T> T unwrap(Class<T> statementClass) throws SQLException {
        return this.statement.unwrap(statementClass);
    }

    @Override
    public final void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public final boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " for " + this.caller[0];
    }
}

