/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import patterntesting.runtime.util.NestedZipFile;

public abstract class AbstractDigger {
    private static final Logger LOG = LogManager.getLogger(AbstractDigger.class);

    protected static Collection<String> readElementsFromNestedArchive(File archive) throws IOException {
        String path = StringUtils.removeEnd((String)archive.getPath(), (String)"!");
        String archiveDir = "";
        if (!path.toLowerCase().matches(".*\\.[jwe]ar")) {
            archiveDir = StringUtils.substringAfterLast((String)path, (String)"!");
            archiveDir = FilenameUtils.separatorsToUnix((String)archiveDir);
            path = StringUtils.substringBeforeLast((String)path, (String)"!");
        }
        return AbstractDigger.readElementsFromArchive(new File(path), archiveDir);
    }

    private static Collection<String> readElementsFromArchive(File archive, String archiveDir) throws IOException {
        ArrayList<String> elements = new ArrayList<String>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (NestedZipFile zipFile = new NestedZipFile(archive);){
            String relPath = archiveDir.startsWith("/") ? archiveDir.substring(1) : archiveDir;
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(relPath)) continue;
                elements.add(name.substring(relPath.length()));
            }
            LOG.trace("{} element(s) read from {}.", (Object)elements.size(), (Object)archive);
            return elements;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

