/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import patterntesting.runtime.annotation.ProfileMe;
import patterntesting.runtime.monitor.AbstractProfileAspect;
import patterntesting.runtime.monitor.ProfileAspect;
import patterntesting.runtime.monitor.ProfileMonitor;
import patterntesting.runtime.monitor.ProfileStatistic;
import patterntesting.runtime.monitor.internal.ClasspathDigger;
import patterntesting.runtime.util.Converter;
import patterntesting.runtime.util.ObjectComparator;

public final class DoubletDigger {
    private static final Logger LOG;
    private final Map<Class<?>, Boolean> doubletClasses = new ConcurrentHashMap();
    private final ClassLoader cloader;
    private final ClasspathDigger classpathDigger;
    private final List<Class<?>> doubletList = new CopyOnWriteArrayList();
    private boolean multiThreadingEnabled = DoubletDigger.getMultiThreadingEnabled();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        DoubletDigger.ajc$preClinit();
        LOG = LogManager.getLogger(DoubletDigger.class);
    }

    public DoubletDigger(ClasspathDigger classpathDigger) {
        this.classpathDigger = classpathDigger;
        this.cloader = classpathDigger.getClassLoader();
    }

    protected final void reset() {
        this.doubletList.clear();
    }

    public boolean isDoublet(Class<?> clazz) {
        Boolean doublet = this.doubletClasses.get(clazz);
        if (doublet == null) {
            String classname = clazz.getName();
            String resource = Converter.classToResource(classname);
            try {
                doublet = this.isDoublet(resource);
            }
            catch (NoSuchElementException ex) {
                LOG.trace("{} is not found:", (Throwable)ex);
                LOG.debug("{} is a proxy or similar class because classloader does not find it:", clazz);
                doublet = false;
            }
            this.doubletClasses.put(clazz, doublet);
        }
        return doublet;
    }

    public boolean isDoublet(String name) {
        Enumeration<URL> resources = this.classpathDigger.getResources(name);
        if (!resources.hasMoreElements()) {
            throw new NoSuchElementException("resource '" + name + "' not found");
        }
        String rsc = resources.nextElement().toString();
        while (resources.hasMoreElements()) {
            String doublet = resources.nextElement().toString();
            if (rsc.equals(doublet)) continue;
            this.logDoublets(name);
            return true;
        }
        return false;
    }

    public URI getDoublet(String name, int nr) {
        Enumeration<URL> resources = this.classpathDigger.getResources(name);
        int i = 0;
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (i == nr) {
                try {
                    return url.toURI();
                }
                catch (URISyntaxException ex) {
                    LOG.debug("Cannot convert {} to URI:", (Object)url, (Object)ex);
                    return URI.create(url.toString());
                }
            }
            ++i;
        }
        return null;
    }

    public URI getDoublet(Class<?> clazz, int nr) {
        String resource = Converter.classToResource(clazz.getName());
        return this.getDoublet(resource, nr);
    }

    private void logDoublets(String name) {
        if (LOG.isTraceEnabled()) {
            ArrayList<URL> doublets = new ArrayList<URL>();
            Enumeration<URL> resources = this.classpathDigger.getResources(name);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                doublets.add(url);
            }
            LOG.trace("{} doublets found: {}", (Object)name, doublets);
        }
    }

    public String[] getDoubletClasses() {
        LOG.debug("Calculating doublet classes...");
        List<Class<?>> classes = this.getDoubletClassList();
        String[] doublets = new String[classes.size()];
        int i = 0;
        while (i < doublets.length) {
            doublets[i] = classes.get(i).toString();
            ++i;
        }
        LOG.debug("Calculating doublet classes successful finished with {} doublet(s) found.", (Object)doublets.length);
        return doublets;
    }

    public String[] getDoubletResources() {
        LOG.debug("Calculating doublet resources...");
        List<String> resources = this.getDoubletResourceList();
        LOG.debug("Calculating doublet classes successful finished with {} doublet(s) found.", (Object)resources.size());
        return resources.toArray(new String[resources.size()]);
    }

    @ProfileMe
    public synchronized List<Class<?>> getDoubletClassList() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        return (List)DoubletDigger.getDoubletClassList_aroundBody1$advice(this, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    @ProfileMe
    public synchronized List<String> getDoubletResourceList() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        return (List)DoubletDigger.getDoubletResourceList_aroundBody3$advice(this, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Class<?>> getDoubletListSerial() {
        List<Class<?>> loadedClassList = this.classpathDigger.getLoadedClasses();
        List<Class<?>> list = this.doubletList;
        synchronized (list) {
            for (Class<?> clazz : loadedClassList) {
                if (this.doubletList.contains(clazz)) continue;
                try {
                    if (!this.isDoublet(clazz)) continue;
                    this.doubletList.add(clazz);
                }
                catch (NoSuchElementException nsee) {
                    LOG.trace("{} not found -> ignored:", clazz, (Object)nsee);
                }
            }
            this.sortDoubletList();
        }
        return Collections.unmodifiableList(this.doubletList);
    }

    private void sortDoubletList() {
        try {
            Collections.sort(this.doubletList, new ObjectComparator());
        }
        catch (UnsupportedOperationException ex) {
            LOG.debug("Will sort doubletList with fallback because Collections.sort(..) failed:", (Throwable)ex);
            DoubletDigger.sortList(this.doubletList);
        }
    }

    private static void sortList(List<Class<?>> list) {
        ArrayList sorted = new ArrayList(list.size());
        Collections.sort(sorted, new ObjectComparator());
        list.clear();
        list.addAll(sorted);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " for " + this.cloader;
    }

    private static boolean getMultiThreadingEnabled() {
        boolean enabled = Boolean.getBoolean(System.getProperty("multiThreadingEnabled", "false"));
        if (enabled) {
            LOG.debug("Multi threading is enabled.");
            return true;
        }
        int n = Runtime.getRuntime().availableProcessors();
        enabled = n > 1;
        LOG.debug("{} processors found, multi threading is {}enabled.", (Object)n, (Object)(enabled ? "" : "not "));
        return enabled;
    }

    public boolean isMultiThreadingEnabled() {
        return this.multiThreadingEnabled;
    }

    public void setMultiThreadingEnabled(boolean enabled) {
        this.multiThreadingEnabled = enabled;
    }

    protected List<Class<?>> getDoubletListParallel() {
        List<Class<?>> loadedClassList = this.classpathDigger.getLoadedClasses();
        if (loadedClassList.isEmpty()) {
            return loadedClassList;
        }
        LOG.trace("Creating queue with {} elements for synchronisation.", (Object)loadedClassList.size());
        ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue(loadedClassList);
        Class<?> lastClass = loadedClassList.get(loadedClassList.size() - 1);
        if (this.isDoublet(lastClass)) {
            this.doubletList.add(lastClass);
        }
        LOG.trace("Creating multiple threads.");
        int n = 2;
        List[] l = new List[n];
        DoubletDiggerRunner[] d = new DoubletDiggerRunner[n];
        Thread[] t = new Thread[n];
        int i = 0;
        while (i < n) {
            l[i] = new ArrayList();
            d[i] = new DoubletDiggerRunner(queue, lastClass, l[i]);
            t[i] = new Thread(d[i]);
            t[i].start();
            ++i;
        }
        LOG.debug("Starting {} threads...", (Object)n);
        i = 0;
        while (i < n) {
            try {
                LOG.trace("{} started...", (Object)t[i]);
                t[i].join();
                LOG.trace("{} finished.", (Object)t[i]);
            }
            catch (InterruptedException ie) {
                LOG.info("Waiting for {} threads are interrupted:", (Object)n, (Object)ie);
                Thread.currentThread().interrupt();
            }
            ++i;
        }
        LOG.debug("Starting {} threads finished - will add results to doublet list.", (Object)n);
        i = 0;
        while (i < n) {
            this.doubletList.addAll(l[i]);
            ++i;
        }
        this.sortDoubletList();
        LOG.trace("Result of {} threads was added to doublet list and sorted.", (Object)n);
        return Collections.unmodifiableList(this.doubletList);
    }

    private static final /* synthetic */ List getDoubletClassList_aroundBody0(DoubletDigger ajc$this, JoinPoint joinPoint) {
        if (ajc$this.multiThreadingEnabled) {
            return ajc$this.getDoubletListParallel();
        }
        return ajc$this.getDoubletListSerial();
    }

    private static final /* synthetic */ Object getDoubletClassList_aroundBody1$advice(DoubletDigger ajc$this, JoinPoint thisJoinPoint, AbstractProfileAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        Signature sig = thisJoinPoint2.getSignature();
        ProfileMonitor mon = ProfileStatistic.start(sig);
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            List list = DoubletDigger.getDoubletClassList_aroundBody0(ajc$this, thisJoinPoint);
            return list;
        }
        finally {
            mon.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log(ajc$aspectInstance, thisJoinPoint2, mon.getLastValue());
        }
    }

    private static final /* synthetic */ List getDoubletResourceList_aroundBody2(DoubletDigger ajc$this, JoinPoint joinPoint) {
        List<String> loadedResources = ajc$this.classpathDigger.getLoadedResources();
        ArrayList<String> doubletResources = new ArrayList<String>();
        for (String rsc : loadedResources) {
            if (!ajc$this.isDoublet(rsc)) continue;
            doubletResources.add(rsc);
        }
        return doubletResources;
    }

    private static final /* synthetic */ Object getDoubletResourceList_aroundBody3$advice(DoubletDigger ajc$this, JoinPoint thisJoinPoint, AbstractProfileAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        Signature sig = thisJoinPoint2.getSignature();
        ProfileMonitor mon = ProfileStatistic.start(sig);
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            List list = DoubletDigger.getDoubletResourceList_aroundBody2(ajc$this, thisJoinPoint);
            return list;
        }
        finally {
            mon.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log(ajc$aspectInstance, thisJoinPoint2, mon.getLastValue());
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DoubletDigger.java", DoubletDigger.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "getDoubletClassList", "patterntesting.runtime.monitor.internal.DoubletDigger", "", "", "", "java.util.List"), 225);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "getDoubletResourceList", "patterntesting.runtime.monitor.internal.DoubletDigger", "", "", "", "java.util.List"), 239);
    }

    class DoubletDiggerRunner
    implements Runnable {
        private final Queue<Class<?>> queue;
        private final Class<?> lastClass;
        private final List<Class<?>> newDoublets;

        public DoubletDiggerRunner(Queue<Class<?>> queue, Class<?> lastClass, List<Class<?>> newDoublets) {
            this.queue = queue;
            this.lastClass = lastClass;
            this.newDoublets = newDoublets;
        }

        @Override
        public void run() {
            LOG.debug("Running {}...", (Object)this);
            while (!this.queue.isEmpty()) {
                try {
                    Class<?> clazz = this.queue.remove();
                    if (clazz.equals(this.lastClass)) {
                        LOG.trace("Last {} reached.", clazz);
                        this.queue.add(clazz);
                        break;
                    }
                    if (DoubletDigger.this.doubletList.contains(clazz) || !DoubletDigger.this.isDoublet(clazz)) continue;
                    this.newDoublets.add(clazz);
                }
                catch (NoSuchElementException nsee) {
                    LOG.debug("No element from {} found:", this.queue, (Object)nsee);
                }
            }
            LOG.debug("Running {} finished with {} doublets found.", (Object)this, (Object)this.newDoublets.size());
        }

        public String toString() {
            return "DoubletDigger-" + Thread.currentThread().getId();
        }
    }
}

