/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor.internal;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import patterntesting.runtime.exception.ClassloaderException;
import patterntesting.runtime.monitor.internal.ClasspathDigger;
import patterntesting.runtime.monitor.internal.ResourceWalker;
import patterntesting.runtime.util.Converter;

public class ResourcepathDigger
extends ClasspathDigger {
    private static final Logger LOG = LogManager.getLogger(ResourcepathDigger.class);

    public ResourcepathDigger() {
    }

    public ResourcepathDigger(ClassLoader cloader) {
        super(cloader);
    }

    public Set<String> getResources() {
        TreeSet<String> resourceSet = new TreeSet<String>();
        String[] stringArray = this.getClasspath();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            ResourcepathDigger.addResources(resourceSet, new File(path));
            ++n2;
        }
        return resourceSet;
    }

    public static URI whichResource(String name, ClassLoader cloader) {
        assert (cloader != null) : "no classloader given";
        URL url = cloader.getResource(name);
        if (url == null) {
            String newName = name.startsWith("/") ? name.substring(1) : "/" + name;
            try {
                url = cloader.getResource(newName);
            }
            catch (RuntimeException ex) {
                throw new ClassloaderException(cloader, "cannot get resource \"" + name + "\"", ex);
            }
        }
        if (url == null) {
            ClassLoader parent = cloader.getParent();
            if (parent == null) {
                return null;
            }
            ClasspathDigger.LOG.trace("{} not found with {}, will ask {}...", (Object)name, (Object)cloader, (Object)parent);
            return ResourcepathDigger.whichResource(name, parent);
        }
        return Converter.toURI(url);
    }

    private static void addResources(Set<String> resourceSet, File path) {
        LOG.trace("Adding resources from {}...", (Object)path);
        try {
            if (path.isDirectory()) {
                ResourcepathDigger.addResourcesFromDir(resourceSet, path);
            } else {
                ResourcepathDigger.addElementsFromArchive(resourceSet, path);
            }
        }
        catch (IOException ioe) {
            LOG.warn("Cannot add classes from " + path.getAbsolutePath() + ":", (Throwable)ioe);
        }
    }

    private static void addResourcesFromDir(Set<String> resourceSet, File dir) throws IOException {
        ResourceWalker walker = new ResourceWalker(dir);
        Collection<String> resources = walker.getResources();
        resourceSet.addAll(resources);
    }

    private static void addElementsFromArchive(Set<String> resourceSet, File path) throws IOException {
        Collection<String> allElements = ResourcepathDigger.readElementsFromNestedArchive(path);
        for (String resource : allElements) {
            if (resource.endsWith(".class") || resource.endsWith("/")) continue;
            resourceSet.add(resource.startsWith("/") ? resource : "/" + resource);
        }
    }
}

