/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Localhost {
    private static final Logger LOG = LogManager.getLogger(Localhost.class);
    private static final Collection<InetAddress> inetAddresses = new ArrayList<InetAddress>();

    static {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    inetAddresses.add(address);
                }
            }
        }
        catch (SocketException ex) {
            LOG.debug("can't get local NetworkInterfaces ({})", (Object)ex.getMessage());
            LOG.trace("Details:", (Throwable)ex);
        }
    }

    private Localhost() {
    }

    public static Collection<InetAddress> getInetAddresses() {
        return Collections.unmodifiableCollection(inetAddresses);
    }

    public static boolean matches(String[] hosts) {
        int i = 0;
        while (i < hosts.length) {
            if (Localhost.matches(hosts[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean matches(String host) {
        for (InetAddress address : inetAddresses) {
            if (!host.equals(address.getHostAddress()) && !host.equals(address.getHostName())) continue;
            return true;
        }
        return false;
    }
}

