/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import patterntesting.runtime.util.Converter;
import patterntesting.runtime.util.NestedZipFile;

public final class ArchivEntry {
    private static final Logger LOG = LogManager.getLogger(ArchivEntry.class);
    private final URI uri;
    private Long size = null;

    protected ArchivEntry(File file) {
        this(file.toURI());
    }

    @Deprecated
    public ArchivEntry(String s) throws URISyntaxException {
        this(new URI(s));
    }

    public ArchivEntry(URI uri) {
        this.uri = uri;
    }

    public ArchivEntry(URL url) {
        this(Converter.toURI(url));
    }

    public ArchivEntry(String scheme, File archive, String entry) throws URISyntaxException {
        this(ArchivEntry.toURI(scheme, archive, entry));
    }

    private static URI toURI(String scheme, File archiv, String name) throws URISyntaxException {
        String path = FilenameUtils.separatorsToUnix((String)archiv.getPath());
        String schemeURI = String.valueOf(scheme) + ":" + path + "!/" + name;
        return new URI(schemeURI).normalize();
    }

    public URI toURI() {
        return this.uri;
    }

    public boolean isFile() {
        return StringUtils.isEmpty((CharSequence)this.getEntry());
    }

    @Deprecated
    public File getFile() {
        return this.getFileArchiv();
    }

    public File getFileArchiv() {
        if (this.hasEntry()) {
            String prefix = StringUtils.substringBeforeLast((String)this.uri.toString(), (String)"!");
            return Converter.toFile(prefix);
        }
        return Converter.toFile(this.uri);
    }

    public ZipFile getZipFile() throws IOException {
        try {
            return new NestedZipFile(this.getFileArchiv());
        }
        catch (IOException ioe) {
            throw new IOException("can't get zip file \"" + this.getFileArchiv() + '\"', ioe);
        }
    }

    public String getEntry() {
        if (this.hasEntry()) {
            String path = this.uri.getRawSchemeSpecificPart();
            if (this.isBundleresource()) {
                return StringUtils.substringAfter((String)path.substring(2), (String)"/");
            }
            String entry = StringUtils.substringAfterLast((String)path, (String)"!");
            return entry.charAt(0) == '/' ? entry.substring(1) : entry;
        }
        return "";
    }

    public boolean hasEntry() {
        String path = this.uri.getRawSchemeSpecificPart();
        if (this.isBundleresource()) {
            return path.substring(2).contains("/");
        }
        return path.contains("!");
    }

    private boolean isBundleresource() {
        return "bundleresource".equals(this.uri.getScheme());
    }

    public ZipEntry getZipEntry() {
        return new ZipEntry(this.getEntry());
    }

    public long getSize() throws IOException {
        if (this.size == null) {
            if (this.isFile()) {
                this.size = this.getFileArchiv().length();
            } else {
                String entry;
                ZipFile zipFile = this.getZipFile();
                ZipEntry zipEntry = zipFile.getEntry(entry = this.getEntry());
                if (zipEntry == null) {
                    throw new ZipException("entry '" + entry + "' not found in " + zipFile);
                }
                this.size = zipEntry.getSize();
            }
        }
        return this.size;
    }

    public byte[] getBytes() throws IOException {
        InputStream istream = this.uri.toURL().openStream();
        assert (istream != null);
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)istream);
            return byArray;
        }
        finally {
            istream.close();
        }
    }

    public boolean equals(Object other) {
        if (other instanceof ArchivEntry) {
            return this.isEqualsWith((ArchivEntry)other);
        }
        return false;
    }

    private boolean isEqualsWith(ArchivEntry other) {
        block4: {
            if (!StringUtils.equals((CharSequence)this.getEntry(), (CharSequence)other.getEntry())) {
                return false;
            }
            try {
                if (this.getSize() == other.getSize()) break block4;
                return false;
            }
            catch (IOException ioe) {
                LOG.info("Will use URI for comparison because cannot compare content of {} with {}.", (Object)this, (Object)other);
                LOG.debug("Details:", (Throwable)ioe);
                return this.uri.equals(other.uri);
            }
        }
        return Arrays.equals(this.getBytes(), other.getBytes());
    }

    public int hashCode() {
        if (this.size == null) {
            return 0;
        }
        return this.size.hashCode();
    }

    public String toString() {
        return "ArchivEntry " + this.uri;
    }
}

