/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.util;

import java.util.Set;
import javax.validation.Validator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AssertArg {
    private static final Logger LOG = LogManager.getLogger(AssertArg.class);

    private AssertArg() {
    }

    public static void isValid(Validator validatable) {
        AssertArg.isValid(validatable, validatable);
    }

    public static void isValid(Object argument, Validator validator) {
        if (argument == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (validator == null) {
            LOG.debug("No validator given to validate {}.", argument);
        } else {
            Set violations = validator.validate(argument, new Class[0]);
            if (violations != null && !violations.isEmpty()) {
                throw new IllegalArgumentException(argument + " is invalid: " + violations);
            }
        }
    }
}

