/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.util;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import patterntesting.runtime.util.Converter;

public final class ClasspathHelper {
    private static final Logger LOG = LogManager.getLogger(ClasspathHelper.class);

    private ClasspathHelper() {
    }

    public static URI getParent(URI path, String resource) {
        String p = ClasspathHelper.removeTrailingSlash(path.toString());
        String res = ClasspathHelper.removeTrailingSlash(resource);
        String parent = StringUtils.removeEnd((String)p, (String)res);
        if ((parent = ClasspathHelper.removeTrailingSlash(parent)).endsWith("!")) {
            parent = parent.substring(0, parent.length() - 1);
        }
        try {
            return new URI(parent);
        }
        catch (URISyntaxException canthappen) {
            LOG.error("can't extract " + resource + " from " + path, (Throwable)canthappen);
            return path;
        }
    }

    private static String removeTrailingSlash(String s) {
        if (s.endsWith("/") || s.endsWith("\\")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static URI getParent(URI path, Class<?> clazz) {
        String resource = Converter.toResource(clazz);
        return ClasspathHelper.getParent(path, resource);
    }
}

