/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class NestedZipFile
extends ZipFile {
    private static final Logger LOG = LogManager.getLogger(NestedZipFile.class);

    public NestedZipFile(String name) throws IOException {
        this(new File(name));
    }

    public NestedZipFile(File file) throws IOException {
        this(file, Charset.defaultCharset());
    }

    public NestedZipFile(File file, int mode) throws IOException {
        this(file, mode, Charset.defaultCharset());
    }

    public NestedZipFile(String name, Charset charset) throws IOException {
        this(new File(name), charset);
    }

    public NestedZipFile(File file, Charset charset) throws IOException {
        this(file, 1, charset);
    }

    public NestedZipFile(File file, int mode, Charset charset) throws IOException {
        super(NestedZipFile.getEmbeddedZipFile(file), mode, charset);
    }

    private static File getEmbeddedZipFile(File file) throws IOException {
        String path = file.getPath();
        if (path.contains("!")) {
            String[] pathes = path.split("!");
            return NestedZipFile.getEmbeddedZipFile(new File(pathes[0]), Arrays.copyOfRange(pathes, 1, pathes.length));
        }
        return file;
    }

    private static File getEmbeddedZipFile(File embeddingZip, String[] pathes) throws IOException {
        File embedded = NestedZipFile.getEmbbededZipFile(embeddingZip, pathes[0]);
        if (pathes.length > 1) {
            return NestedZipFile.getEmbeddedZipFile(embedded, Arrays.copyOfRange(pathes, 1, pathes.length));
        }
        return embedded;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File getEmbbededZipFile(File file, String name) throws IOException {
        String normalizedName = FilenameUtils.separatorsToUnix((String)name.substring(1));
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            ZipFile zipFile;
            block8: {
                zipFile = new ZipFile(file);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                finally {
                    if (!entries.hasMoreElements()) break block8;
                }
                ZipEntry entry = entries.nextElement();
                if (normalizedName.equals(entry.getName())) {
                    return NestedZipFile.getEmbeddedZipFile(zipFile, entry);
                }
            }
            if (zipFile == null) throw new FileNotFoundException("entry '" + name + "' not found in " + file);
            zipFile.close();
            throw new FileNotFoundException("entry '" + name + "' not found in " + file);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private static File getEmbeddedZipFile(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream istream = zipFile.getInputStream(zipEntry);){
            File tmpZipFile = File.createTempFile(zipEntry.getName(), ".zip");
            tmpZipFile.deleteOnExit();
            FileOutputStream ostream = new FileOutputStream(tmpZipFile);
            IOUtils.copy((InputStream)istream, (OutputStream)ostream);
            ((OutputStream)ostream).close();
            LOG.debug("File {} created with '{}' from file '{}'.", (Object)tmpZipFile, (Object)zipEntry, (Object)zipFile.getName());
            return tmpZipFile;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String toString() {
        return "ZipFile '" + this.getName() + "'";
    }
}

