/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import patterntesting.runtime.exception.NotFoundException;
import patterntesting.runtime.util.Converter;
import patterntesting.runtime.util.ReflectionHelper;
import patterntesting.runtime.util.ThreadUtil;

@Deprecated
public final class ObjectInspector {
    public static final String NOTHING_FOUND = null;
    private static final Logger LOG = LogManager.getLogger(ObjectInspector.class);
    private final Object inspected;
    private final Set<Object> visited = new HashSet<Object>();

    public ObjectInspector(Object obj) {
        this.inspected = obj;
    }

    public Class<?> getType() {
        return this.inspected.getClass();
    }

    public String findValue(Object value) throws NotFoundException {
        try {
            String string = this.findValue(value, this.inspected, this.inspected.getClass().getName());
            return string;
        }
        finally {
            this.visited.clear();
        }
    }

    private String findValue(Object value, Object where, String path) throws NotFoundException {
        for (Field field : ObjectInspector.getAllFields(where.getClass())) {
            field.setAccessible(true);
            try {
                Object obj = field.get(where);
                String fieldPath = String.valueOf(path) + "." + field.getName();
                if (ObjectInspector.isEquals(obj, value)) {
                    return fieldPath;
                }
                if (this.alreadyVisited(obj)) continue;
                if (ObjectInspector.isArrayType(obj)) {
                    return this.findArrayValue(value, obj, fieldPath);
                }
                if (ObjectInspector.isIterable(obj)) {
                    return this.findValue(value, ObjectInspector.getIterator(obj), fieldPath);
                }
                if (!ObjectInspector.isComplexType(obj)) continue;
                try {
                    return this.findValue(value, obj, fieldPath);
                }
                catch (NotFoundException vnfe) {
                    LOG.trace("Value not found in " + path + "." + field + ":", (Throwable)vnfe);
                }
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException("can't access " + field + " in " + where.getClass(), ex);
            }
        }
        throw new NotFoundException(value);
    }

    private String findArrayValue(Object value, Object where, String path) throws NotFoundException {
        try {
            Object[] objects = (Object[])where;
            int i = 0;
            while (i < objects.length) {
                String arrayPath = String.valueOf(path) + "[" + i + "]";
                if (ObjectInspector.isEquals(value, objects[i])) {
                    return arrayPath;
                }
                if (objects[i] != null) {
                    try {
                        return this.findValue(value, objects[i], String.valueOf(path) + ".");
                    }
                    catch (NotFoundException vnfe) {
                        LOG.trace("Value not found in ", (Object)(String.valueOf(arrayPath) + ":"), (Object)vnfe);
                    }
                }
                ++i;
            }
        }
        catch (ClassCastException cce) {
            LOG.trace("Cannot look in native array " + where + " for " + value + ":", (Throwable)cce);
        }
        throw new NotFoundException(value);
    }

    private String findValue(Object value, Iterator<?> where, String path) throws NotFoundException {
        int i = 0;
        while (where.hasNext()) {
            String arrayPath = String.valueOf(path) + "[" + i + "]";
            try {
                Object obj = where.next();
                if (ObjectInspector.isEquals(value, obj)) {
                    return arrayPath;
                }
                return this.findValue(value, obj, arrayPath);
            }
            catch (NotFoundException vnfe) {
                LOG.trace("value not found in {}:", (Object)arrayPath, (Object)vnfe);
            }
            catch (ConcurrentModificationException ex) {
                LOG.trace("Cannot iterate {}:", (Object)arrayPath, (Object)ex);
            }
        }
        throw new NotFoundException(value);
    }

    private static boolean isEquals(Object one, Object two) {
        if (one == null) {
            return two == null;
        }
        if (two == null) {
            return false;
        }
        if (one.equals(two)) {
            return true;
        }
        if (one instanceof Pattern) {
            Pattern pattern = (Pattern)one;
            return pattern.matcher(two.toString()).matches();
        }
        return false;
    }

    public Collection<Field> getAllFields() {
        return ObjectInspector.getAllFields(this.inspected.getClass());
    }

    private static Collection<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ObjectInspector.addFields(fields, clazz);
        return fields;
    }

    private static void addFields(Collection<Field> fields, Class<?> clazz) {
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            ObjectInspector.addFields(fields, superclass);
        }
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
    }

    public synchronized void dump(Writer writer) throws IOException {
        writer.append("=== Dump of " + this.inspected.getClass() + " ===\n");
        this.dump(writer, this.inspected, this.inspected.getClass().getName());
        this.visited.clear();
    }

    private void dump(Writer writer, Object obj, String prefix) throws IOException {
        if (obj == null) {
            writer.append(String.valueOf(prefix) + "(null)\n");
            return;
        }
        Collection<Field> fields = ObjectInspector.getAllFields(obj.getClass());
        for (Field field : fields) {
            ObjectInspector.dump(writer, field, obj, prefix);
            try {
                Object value = field.get(obj);
                if (value == null || this.alreadyVisited(value)) continue;
                if (ObjectInspector.isArrayType(value)) {
                    this.dumpArray(writer, value, prefix);
                    continue;
                }
                if (ObjectInspector.isIterable(value)) {
                    this.dumpIterable(writer, value, prefix);
                    continue;
                }
                if (!ObjectInspector.isComplexType(value)) continue;
                this.dump(writer, value, String.valueOf(prefix) + "." + field.getName());
            }
            catch (IllegalAccessException iae) {
                throw new IllegalArgumentException("can't access " + field, iae);
            }
        }
    }

    private void dumpIterable(Writer writer, Object value, String prefix) throws IOException {
        try {
            Iterator<?> iterator = ObjectInspector.getIterator(value);
            int i = 0;
            while (iterator.hasNext()) {
                Object next = iterator.next();
                this.dump(writer, next, String.valueOf(prefix) + "[" + i + "]");
                ++i;
            }
        }
        catch (ConcurrentModificationException cme) {
            LOG.warn("Houston, we have a problem with iterator of " + value, (Throwable)cme);
            writer.append(String.valueOf(prefix) + "[..]");
            writer.append(" = ??? (" + cme + ")\n");
            ThreadUtil.sleep();
        }
    }

    private static void dump(Writer writer, Field field, Object obj, String prefix) throws IOException {
        field.setAccessible(true);
        writer.append(prefix);
        writer.append('.');
        writer.append(field.getName());
        writer.append(" = (");
        writer.append(field.getType().getSimpleName());
        writer.append(") ");
        try {
            writer.append(Converter.toString(field.get(obj)));
        }
        catch (IllegalAccessException iae) {
            LOG.debug("can't access field {}", (Object)field, (Object)iae);
            writer.append("??? (");
            writer.append(iae.getLocalizedMessage());
            writer.append(")");
        }
        writer.append("\n");
    }

    private void dumpArray(Writer writer, Object value, String prefix) throws IOException {
        try {
            Object[] array = (Object[])value;
            int i = 0;
            while (i < array.length) {
                this.dump(writer, array[i], String.valueOf(prefix) + "[" + i + "]");
                ++i;
            }
        }
        catch (ClassCastException cce) {
            LOG.trace("Native array " + value + " is not dumped with each element.", (Throwable)cce);
        }
    }

    public boolean isComplexType() {
        return ObjectInspector.isComplexType(this.inspected);
    }

    public static boolean isComplexType(Object obj) {
        if (obj == null) {
            return false;
        }
        Class<?> clazz = obj.getClass();
        if (clazz.isPrimitive()) {
            return false;
        }
        if (String.class.equals(clazz)) {
            return false;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return false;
        }
        return !Character.class.isAssignableFrom(clazz);
    }

    public boolean isArrayType() {
        return ObjectInspector.isArrayType(this.inspected);
    }

    public static boolean isArrayType(Object obj) {
        if (obj == null) {
            return false;
        }
        Class<?> clazz = obj.getClass();
        return clazz.isArray();
    }

    public boolean isIterable() {
        return ObjectInspector.isIterable(this.inspected);
    }

    public static boolean isIterable(Object obj) {
        if (obj == null) {
            return false;
        }
        Class<?> clazz = obj.getClass();
        try {
            clazz.getMethod("iterator", new Class[0]);
            return true;
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("can't access methods for " + clazz, e);
        }
        catch (NoSuchMethodException e) {
            LOG.debug(obj + " has no iterator:", (Throwable)e);
            return false;
        }
    }

    private static Iterator<?> getIterator(Object value) {
        return (Iterator)ReflectionHelper.invokeMethod(value, "iterator", new Object[0]);
    }

    private boolean alreadyVisited(Object value) {
        block3: {
            if (!this.visited.contains(value)) break block3;
            return true;
        }
        try {
            this.visited.add(value);
        }
        catch (RuntimeException ex) {
            LOG.debug("can't store \"{}\"", value, (Object)ex);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " for " + this.inspected.getClass();
    }

    public String toLongString() {
        StringBuilder buffer = new StringBuilder();
        Class<?> clazz = this.inspected.getClass();
        while (clazz != null) {
            buffer.insert(0, this.toString(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return buffer.toString();
    }

    private String toString(Field[] fields) {
        return ObjectInspector.toString(fields, this.inspected);
    }

    private static String toString(Field[] fields, Object obj) {
        StringWriter buffer = new StringWriter();
        try {
            int i = 0;
            while (i < fields.length) {
                ObjectInspector.dump(buffer, fields[i], obj, "");
                ++i;
            }
            buffer.close();
        }
        catch (IOException canthappen) {
            LOG.info("I have some problems dumping fields {}.", (Object)fields, (Object)canthappen);
        }
        return buffer.toString();
    }
}

