/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import patterntesting.annotation.check.runtime.MayReturnNull;
import patterntesting.runtime.util.Converter;

public class ReflectionHelper {
    private static final Logger LOG = LogManager.getLogger(ReflectionHelper.class);

    private ReflectionHelper() {
    }

    public static Field getField(Class<?> cl, String name) throws NoSuchFieldException {
        try {
            Field field = cl.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            Class<?> superclass = cl.getSuperclass();
            if (superclass == null) {
                throw e;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("using " + superclass + " to get " + cl.getName() + "." + name + "...");
            }
            return ReflectionHelper.getField(superclass, name);
        }
    }

    public static boolean hasField(Object obj, String name) {
        return ReflectionHelper.hasField(obj.getClass(), name);
    }

    public static boolean hasField(Class<?> clazz, String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        try {
            ReflectionHelper.getField(clazz, name);
            return true;
        }
        catch (NoSuchFieldException ex) {
            LOG.debug("Will return false because {} has no field '{}' ({}).", clazz, (Object)name, (Object)ex);
            return false;
        }
    }

    public static Object getFieldValue(Object target, String name) throws ReflectiveOperationException {
        Field field = ReflectionHelper.getField(target.getClass(), name);
        return field.get(target);
    }

    public static void setFieldValue(Object target, String name, String value) throws ReflectiveOperationException {
        Field field = ReflectionHelper.getField(target.getClass(), name);
        field.set(target, value);
    }

    public static Collection<Field> getUninitializedNonStaticFields(Object obj) {
        ArrayList<Field> unitializedFields = new ArrayList<Field>();
        Field[] fields = obj.getClass().getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            try {
                fields[i].setAccessible(true);
                if (fields[i].get(obj) == null && !ReflectionHelper.isStatic(fields[i])) {
                    unitializedFields.add(fields[i]);
                }
            }
            catch (IllegalArgumentException e) {
                LOG.info(e + " => " + fields[i] + " ignored");
            }
            catch (IllegalAccessException e) {
                LOG.debug("Cannot access " + fields[i] + " => ignored: ", (Throwable)e);
            }
            ++i;
        }
        return unitializedFields;
    }

    public static boolean isStatic(Field field) {
        int m = field.getModifiers();
        return Modifier.isStatic(m);
    }

    public static String toShortString(Field field) {
        return String.valueOf(field.getType().getSimpleName()) + " " + field.getName();
    }

    public static String toShortString(Collection<Field> fields) {
        StringBuilder sbuf = new StringBuilder();
        for (Field field : fields) {
            sbuf.append(", ");
            sbuf.append(ReflectionHelper.toShortString(field));
        }
        return sbuf.substring(2);
    }

    public static Method getMethod(Class<?> cl, String name, Object ... args) throws NoSuchMethodException {
        Class[] parameterTypes = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            parameterTypes[i] = args[i].getClass();
            ++i;
        }
        return ReflectionHelper.getMethod(cl, name, parameterTypes);
    }

    public static Method getMethod(Class<?> cl, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        try {
            return cl.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException origException) {
            try {
                return ReflectionHelper.getMethodFromSuperclass(cl, name, origException, parameterTypes);
            }
            catch (NoSuchMethodException derived) {
                LOG.debug("Method '{}' also not found in superclass:", (Object)name, (Object)derived);
                throw origException;
            }
        }
    }

    private static Method getMethodFromSuperclass(Class<?> cl, String name, NoSuchMethodException origException, Class<?> ... parameterTypes) throws NoSuchMethodException {
        try {
            return ReflectionHelper.findMethod(cl, name, parameterTypes);
        }
        catch (NoSuchMethodException nsme) {
            Class<?> superclass = cl.getSuperclass();
            if (superclass == null) {
                LOG.debug("No method '{}' and no superclass for {} found:", (Object)name, cl, (Object)nsme);
                throw origException;
            }
            return ReflectionHelper.getMethod(superclass, name, parameterTypes);
        }
    }

    private static Method findMethod(Class<?> cl, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Method[] methods = cl.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (name.equals(methods[i].getName()) && ReflectionHelper.matchesParameters(methods[i], parameterTypes)) {
                return methods[i];
            }
            ++i;
        }
        throw new NoSuchMethodException(String.valueOf(cl.getName()) + "." + name + "(" + Converter.toShortString(parameterTypes) + ")");
    }

    private static boolean matchesParameters(Method method, Class<?>[] matchingTypes) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != matchingTypes.length) {
            return false;
        }
        int i = 0;
        while (i < parameterTypes.length) {
            if (!ReflectionHelper.matches(parameterTypes[i], matchingTypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean matches(Class<?> parameterType, Class<?> matchingType) {
        if (parameterType.isAssignableFrom(matchingType)) {
            return true;
        }
        if (parameterType.isPrimitive()) {
            HashMap<Class<Comparable<Boolean>>, Class<Boolean>> mapping = new HashMap<Class<Comparable<Boolean>>, Class<Boolean>>();
            mapping.put(Boolean.TYPE, Boolean.class);
            mapping.put(Byte.TYPE, Byte.class);
            mapping.put(Character.TYPE, Character.class);
            mapping.put(Short.TYPE, Short.class);
            mapping.put(Integer.TYPE, Integer.class);
            mapping.put(Long.TYPE, Long.class);
            mapping.put(Float.TYPE, Float.class);
            mapping.put(Double.TYPE, Double.class);
            mapping.put(Boolean.TYPE, Boolean.class);
            Class mappedType = (Class)mapping.get(parameterType);
            if (mappedType == null) {
                LOG.warn("unknown primitive type \"" + parameterType + "\" not yet supported - sorry!");
                return false;
            }
            return matchingType.equals(mappedType);
        }
        return false;
    }

    public static Object invokeMethod(Object target, String name, Object ... args) {
        try {
            Method method = ReflectionHelper.getMethod(target.getClass(), name, args);
            method.setAccessible(true);
            return method.invoke(target, args);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("no method \"" + name + "(" + ReflectionHelper.toParamString(args) + ")\" in " + target.getClass(), e);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalStateException("can't access method \"" + name + "\" in " + target.getClass(), iae);
        }
        catch (InvocationTargetException ite) {
            throw new IllegalStateException("exception in method \"" + name + "\" of " + target.getClass(), ite.getTargetException());
        }
    }

    private static String toParamString(Object[] args) {
        Object[] paramTypes = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            paramTypes[i] = args[i].getClass();
            ++i;
        }
        return Converter.toShortString(paramTypes);
    }

    public static boolean hasId(Object obj) {
        return ReflectionHelper.hasId(obj.getClass());
    }

    public static boolean hasId(Class<?> clazz) {
        if (ReflectionHelper.getIdField(clazz) != null) {
            return true;
        }
        return ReflectionHelper.getIdGetter(clazz) != null;
    }

    public static Object getId(Object obj) {
        Field idField = ReflectionHelper.getIdField(obj.getClass());
        try {
            if (idField != null) {
                idField.setAccessible(true);
                return idField.get(obj);
            }
            Method getter = ReflectionHelper.getIdGetter(obj.getClass());
            if (getter == null) {
                throw new IllegalArgumentException("no getter for '" + obj + "' available");
            }
            getter.setAccessible(true);
            return getter.invoke(obj, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalArgumentException("cannot get id of " + obj, ex);
        }
    }

    @MayReturnNull
    private static Field getIdField(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            if ("id".equalsIgnoreCase(fields[i].getName())) {
                return fields[i];
            }
            ++i;
        }
        Class<?> superclass = clazz.getSuperclass();
        return superclass == null ? null : ReflectionHelper.getIdField(superclass);
    }

    @MayReturnNull
    private static Method getIdGetter(Class<?> clazz) {
        Method[] methods = clazz.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if ("getid".equalsIgnoreCase(methods[i].getName())) {
                return methods[i];
            }
            ++i;
        }
        Class<?> superclass = clazz.getSuperclass();
        return superclass == null ? null : ReflectionHelper.getIdGetter(superclass);
    }
}

