/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class StringConverter {
    public static final StringConverter ECHO = new EchoConverter();
    public static final StringConverter UPPER_CASE = new UpperCaseConverter();
    public static final StringConverter LOWER_CASE = new LowerCaseConverter();
    public static final StringConverter IGNORE_WHITESPACES = new WhitespaceIgnorer();

    public abstract String convert(String var1);

    public final StringConverter and(StringConverter ... others) {
        return new AndConverter(this, others);
    }

    private static class AndConverter
    extends StringConverter {
        private final List<StringConverter> converters = new ArrayList<StringConverter>();

        public AndConverter(StringConverter first, StringConverter ... others) {
            this.converters.add(first);
            this.converters.addAll(Arrays.asList(others));
        }

        @Override
        public String convert(String input) {
            String output = input;
            for (StringConverter stringConverter : this.converters) {
                output = stringConverter.convert(output);
            }
            return output;
        }
    }

    private static class EchoConverter
    extends StringConverter {
        private EchoConverter() {
        }

        @Override
        public String convert(String input) {
            return input;
        }
    }

    private static class LowerCaseConverter
    extends StringConverter {
        private LowerCaseConverter() {
        }

        @Override
        public String convert(String input) {
            return input.toLowerCase();
        }
    }

    private static class UpperCaseConverter
    extends StringConverter {
        private UpperCaseConverter() {
        }

        @Override
        public String convert(String input) {
            return input.toUpperCase();
        }
    }

    private static class WhitespaceIgnorer
    extends StringConverter {
        private WhitespaceIgnorer() {
        }

        @Override
        public String convert(String input) {
            return StringUtils.trimToEmpty((String)input).replaceAll("\\s", "");
        }
    }
}

