/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.util.reflect;

import java.lang.reflect.Method;
import org.aspectj.lang.reflect.MethodSignature;
import patterntesting.runtime.util.Converter;

public class MethodSignatureImpl
implements MethodSignature {
    private final Method method;

    public MethodSignatureImpl(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public Class<?>[] getExceptionTypes() {
        return this.method.getExceptionTypes();
    }

    public String[] getParameterNames() {
        throw new UnsupportedOperationException("getParameterNames() is not supported");
    }

    public Class<?>[] getParameterTypes() {
        return this.method.getParameterTypes();
    }

    public Class<?> getDeclaringType() {
        return this.method.getDeclaringClass();
    }

    public String getDeclaringTypeName() {
        return this.getDeclaringType().getName();
    }

    public int getModifiers() {
        return this.method.getModifiers();
    }

    public String getName() {
        return this.method.getName();
    }

    public String toLongString() {
        return this.method.toGenericString();
    }

    public String toShortString() {
        return String.valueOf(this.getName()) + "(" + Converter.toShortString(this.getParameterTypes()) + ")";
    }

    public String toString() {
        return this.getReturnType() + " " + this.getDeclaringTypeName() + "." + this.toShortString();
    }
}

