/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Primitives;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.perfectable.introspection.FunctionalReference;
import org.perfectable.introspection.Introspections;
import org.perfectable.introspection.ObjectMethods;
import org.perfectable.introspection.proxy.InvocationHandler;
import org.perfectable.introspection.proxy.MethodInvocation;
import org.perfectable.introspection.proxy.ProxyBuilder;

@Immutable
public final class AnnotationBuilder<A extends Annotation> {
    private final Class<A> annotationType;
    private final ImmutableMap<Method, Object> valueMap;
    private static final Method ANNOTATION_TYPE_METHOD = (Method)Introspections.introspect(Annotation.class).methods().named("annotationType").unique();

    public static <A extends Annotation> A marker(Class<A> annotationType) {
        AnnotationBuilder.checkAnnotationInterface(annotationType);
        Preconditions.checkArgument((annotationType.getDeclaredMethods().length == 0 ? 1 : 0) != 0, (Object)"Annotation interface is not a marker");
        AnnotationInvocationHandler<A> invocationHandler = new AnnotationInvocationHandler<A>(annotationType, (ImmutableMap<Method, Object>)ImmutableMap.of());
        return (A)((Annotation)ProxyBuilder.forInterface(annotationType).instantiate(invocationHandler));
    }

    public static <A extends Annotation> AnnotationBuilder<A> of(Class<A> annotationType) {
        AnnotationBuilder.checkAnnotationInterface(annotationType);
        return new AnnotationBuilder<A>(annotationType, (ImmutableMap<Method, Object>)ImmutableMap.of());
    }

    public <X> AnnotationBuilder<A> with(MemberExtractor<A, X> member, X value) {
        Method method;
        try {
            method = member.introspect().referencedMethod();
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(e);
        }
        Preconditions.checkArgument((boolean)method.getDeclaringClass().equals(this.annotationType), (Object)("Extractor should be a reference to method declared by annotation " + this.annotationType));
        Class memberType = Primitives.wrap(method.getReturnType());
        Preconditions.checkArgument((boolean)memberType.isInstance(value), (String)"Value %s cannot be provided for member %s of type %s", value, (Object)method.getName(), (Object)memberType);
        ImmutableMap newValueMap = ImmutableMap.builder().putAll(this.valueMap).put((Object)method, value).build();
        return new AnnotationBuilder<A>(this.annotationType, (ImmutableMap<Method, Object>)newValueMap);
    }

    public A build() {
        this.validateMembers();
        AnnotationInvocationHandler<A> invocationHandler = new AnnotationInvocationHandler<A>(this.annotationType, this.valueMap);
        return (A)((Annotation)ProxyBuilder.forInterface(this.annotationType).instantiate(invocationHandler));
    }

    private void validateMembers() throws IllegalStateException {
        for (Method method : this.annotationType.getDeclaredMethods()) {
            if (method.getDefaultValue() != null || this.valueMap.containsKey((Object)method)) continue;
            throw new IllegalStateException("No value set for member '" + method.getName() + "'");
        }
    }

    private static void checkAnnotationInterface(Class<?> annotationType) {
        Preconditions.checkArgument((annotationType.isInterface() && annotationType.getInterfaces().length == 1 && annotationType.getInterfaces()[0].equals(Annotation.class) ? 1 : 0) != 0, (Object)"Provided class is not an annotation interface");
    }

    private AnnotationBuilder(Class<A> annotationType, ImmutableMap<Method, Object> valueMap) {
        this.annotationType = annotationType;
        this.valueMap = valueMap;
    }

    private static String formatValue(Object value) {
        if (value instanceof String) {
            return String.format("\"%s\"", value);
        }
        return value.toString();
    }

    private static Object safeInvoke(Method method, Object target) {
        try {
            return method.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Immutable
    private static final class AnnotationInvocationHandler<A>
    implements InvocationHandler<MethodInvocation<A>> {
        private static final int UNCALCULATED_HASH_CODE = -1;
        private static final int MEMBER_NAME_HASH_MULTIPLIER = 127;
        private final Class<A> annotationType;
        private final ImmutableMap<Method, Object> valueMap;
        @LazyInit
        private volatile int cachedHashCode = -1;
        @LazyInit
        private volatile String cachedRepresentation;

        AnnotationInvocationHandler(Class<A> annotationType, ImmutableMap<Method, Object> valueMap) {
            this.annotationType = annotationType;
            this.valueMap = valueMap;
        }

        @Override
        @Nullable
        public Object handle(MethodInvocation<A> invocation) {
            return invocation.decompose(this::calculateMethodResult);
        }

        Object calculateMethodResult(Method method, A receiver, Object ... arguments) {
            if (ObjectMethods.EQUALS.equals(method)) {
                return this.calculateEquals(arguments[0]);
            }
            if (ObjectMethods.HASH_CODE.equals(method)) {
                return this.calculateHash();
            }
            if (ObjectMethods.TO_STRING.equals(method)) {
                return this.calculateRepresentation();
            }
            if (ANNOTATION_TYPE_METHOD.equals(method)) {
                return this.annotationType;
            }
            return this.valueMap.getOrDefault((Object)method, method.getDefaultValue());
        }

        boolean calculateEquals(Object other) {
            if (!(other instanceof Annotation)) {
                return false;
            }
            Annotation otherAnnotation = (Annotation)other;
            Class<? extends Annotation> otherAnnotationType = otherAnnotation.annotationType();
            if (!this.annotationType.equals(otherAnnotationType)) {
                return false;
            }
            for (Method method : this.annotationType.getDeclaredMethods()) {
                Object otherValue;
                Object thisValue = this.valueMap.getOrDefault((Object)method, method.getDefaultValue());
                if (Objects.equals(thisValue, otherValue = AnnotationBuilder.safeInvoke(method, other))) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int calculateHash() {
            if (this.cachedHashCode == -1) {
                AnnotationInvocationHandler annotationInvocationHandler = this;
                synchronized (annotationInvocationHandler) {
                    int current = 0;
                    for (Method method : this.annotationType.getDeclaredMethods()) {
                        Object value = this.valueMap.getOrDefault((Object)method, method.getDefaultValue());
                        String name = method.getName();
                        current += 127 * name.hashCode() ^ Objects.hashCode(value);
                    }
                    this.cachedHashCode = current;
                }
            }
            return this.cachedHashCode;
        }

        private String calculateRepresentation() {
            if (this.cachedRepresentation == null) {
                String elements = this.valueMap.entrySet().stream().map(entry -> entry.getKey() + "=" + AnnotationBuilder.formatValue(entry.getValue())).collect(Collectors.joining(", "));
                this.cachedRepresentation = "@" + this.annotationType.getName() + '(' + elements + ')';
            }
            return this.cachedRepresentation;
        }
    }

    @FunctionalInterface
    public static interface MemberExtractor<A extends Annotation, X>
    extends FunctionalReference {
        @CanIgnoreReturnValue
        public X extract(A var1);
    }
}

