/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection;

import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.perfectable.introspection.PrivilegedActions;
import org.perfectable.introspection.query.AnnotationQuery;
import org.perfectable.introspection.query.ConstructorQuery;
import org.perfectable.introspection.query.FieldQuery;
import org.perfectable.introspection.query.InheritanceQuery;
import org.perfectable.introspection.query.MethodQuery;
import org.perfectable.introspection.type.ClassView;

public final class ClassIntrospection<X> {
    private final Class<X> type;

    static <X> ClassIntrospection<X> of(Class<X> type) {
        return new ClassIntrospection<X>(type);
    }

    public FieldQuery fields() {
        return FieldQuery.of(this.type);
    }

    public ConstructorQuery<X> constructors() {
        return ConstructorQuery.of(this.type);
    }

    public MethodQuery methods() {
        return MethodQuery.of(this.type);
    }

    public InheritanceQuery<X> inheritance() {
        return InheritanceQuery.of(this.type);
    }

    public InheritanceQuery<X> interfaces() {
        return this.inheritance().onlyInterfaces();
    }

    public InheritanceQuery<X> superclasses() {
        return this.inheritance().onlyClasses();
    }

    public AnnotationQuery<Annotation> annotations() {
        return AnnotationQuery.of(this.type);
    }

    public ClassView<X> view() {
        return ClassView.of(this.type);
    }

    public boolean isInstantiable() {
        return !this.type.isInterface() && !this.type.isArray() && (this.type.getModifiers() & 0x400) == 0 && !this.type.isPrimitive();
    }

    public X instantiate() {
        Preconditions.checkState((boolean)this.isInstantiable(), (String)"%s is not isInstantiable", this.type);
        try {
            return this.parameterlessConstructor().newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Constructor<X> parameterlessConstructor() {
        try {
            Constructor<X> constructor = this.type.getDeclaredConstructor(new Class[0]);
            PrivilegedActions.markAccessible(constructor);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public <E extends X> Class<E> asGeneric() {
        return this.type;
    }

    private ClassIntrospection(Class<X> type) {
        this.type = type;
    }
}

