/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection;

import org.perfectable.introspection.query.ClassQuery;

public final class ClassLoaderIntrospection {
    private final ClassLoader classLoader;

    static ClassLoaderIntrospection of(ClassLoader classLoader) {
        return new ClassLoaderIntrospection(classLoader);
    }

    public ClassQuery<Object> classes() {
        return ClassQuery.of(this.classLoader);
    }

    public Class<?> loadSafe(String className) {
        try {
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    private ClassLoaderIntrospection(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

