/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import org.perfectable.introspection.FunctionalReferenceIntrospection;

public interface FunctionalReference
extends Serializable {
    default public Introspection introspect() {
        return FunctionalReferenceIntrospection.of(this);
    }

    public static abstract class PartialVisitor<T>
    implements Visitor<T> {
        @Override
        public T visitStatic(Method method) {
            return this.visitMethod(method);
        }

        @Override
        public T visitInstance(Method method) {
            return this.visitMethod(method);
        }

        @Override
        public T visitBound(Method method, Object boundInstance) {
            return this.visitMethod(method);
        }

        @Override
        public T visitConstructor(Constructor<?> constructor) {
            return this.fallback();
        }

        @Override
        public T visitLambda(Method method, List<Object> captures) {
            return this.fallback();
        }

        protected T visitMethod(Method method) {
            return this.fallback();
        }

        protected abstract T fallback();
    }

    public static interface Visitor<T> {
        public T visitStatic(Method var1);

        public T visitInstance(Method var1);

        public T visitBound(Method var1, Object var2);

        public T visitConstructor(Constructor<?> var1);

        public T visitLambda(Method var1, List<Object> var2);
    }

    public static interface Introspection {
        @CanIgnoreReturnValue
        public <T> T visit(Visitor<T> var1);

        public Class<?> capturingType();

        public Type resultType();

        public int parametersCount();

        public Type parameterType(int var1);

        public Set<Annotation> parameterAnnotations(int var1);

        public Method referencedMethod() throws IllegalStateException;

        public Constructor<?> referencedConstructor() throws IllegalStateException;
    }
}

