/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.perfectable.introspection.ClassLoaderIntrospection;
import org.perfectable.introspection.FunctionalReference;
import org.perfectable.introspection.MethodSignature;
import org.perfectable.introspection.query.ConstructorQuery;
import org.perfectable.introspection.query.MethodQuery;
import org.perfectable.introspection.query.ParametersFilter;
import org.perfectable.introspection.query.TypeFilter;

abstract class FunctionalReferenceIntrospection
implements FunctionalReference.Introspection {
    protected final SerializedLambda serializedForm;
    protected final Class<?> implementationClass;
    protected final Class<?> capturingType;

    static FunctionalReferenceIntrospection of(FunctionalReference marker) {
        Class<?> markerClass = marker.getClass();
        Optional writeReplaceOption = MethodQuery.of(markerClass).named("writeReplace").returning((Type)((Object)Object.class)).asAccessible().option();
        if (writeReplaceOption.isPresent()) {
            Method writeReplace = (Method)writeReplaceOption.get();
            ClassLoader classLoader = markerClass.getClassLoader();
            return FunctionalReferenceIntrospection.ofNativeImplementation(marker, writeReplace, classLoader);
        }
        throw new IllegalArgumentException("Unsupported functional interface implementation " + marker);
    }

    private static FunctionalReferenceIntrospection ofNativeImplementation(FunctionalReference marker, Method writeReplace, ClassLoader classLoader) {
        SerializedLambda serializedForm;
        try {
            serializedForm = (SerializedLambda)writeReplace.invoke((Object)marker, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        switch (serializedForm.getImplMethodKind()) {
            case 5: 
            case 9: {
                switch (serializedForm.getCapturedArgCount()) {
                    case 0: {
                        return new OfInstanceMethod(serializedForm, classLoader);
                    }
                    case 1: {
                        return new OfBoundMethod(serializedForm, classLoader);
                    }
                }
                throw new AssertionError((Object)"Illegal number of captures for invokevirtual");
            }
            case 6: {
                return new OfStaticMethod(serializedForm, classLoader);
            }
            case 7: {
                return new OfLambda(serializedForm, classLoader);
            }
            case 8: {
                return new OfConstructorReference(serializedForm, classLoader);
            }
        }
        throw new AssertionError((Object)"Illegal MethodHandleInfo for lambda");
    }

    @Override
    public final Class<?> capturingType() {
        return this.capturingType;
    }

    @Override
    public Constructor<?> referencedConstructor() {
        throw new IllegalStateException("Interface implementation is not a constructor reference");
    }

    FunctionalReferenceIntrospection(SerializedLambda serializedForm, ClassLoader classLoader) {
        this.serializedForm = serializedForm;
        String declaringTypeName = FunctionalReferenceIntrospection.formatClassName(serializedForm.getImplClass());
        String capturingClassName = FunctionalReferenceIntrospection.formatClassName(serializedForm.getCapturingClass());
        this.capturingType = ClassLoaderIntrospection.of(classLoader).loadSafe(capturingClassName);
        this.implementationClass = ClassLoaderIntrospection.of(classLoader).loadSafe(declaringTypeName);
    }

    private static String formatClassName(String capturingClass) {
        return capturingClass.replaceAll("/", ".");
    }

    protected Class<?> getImplementationClass() {
        return this.implementationClass;
    }

    protected void checkParameterNumber(int number) {
        Preconditions.checkArgument((number >= 0 ? 1 : 0) != 0, (Object)"Parameter number must be non-negative");
        Preconditions.checkArgument((number < this.parametersCount() ? 1 : 0) != 0, (String)"Executable has no parameter with index %s", (int)number);
    }

    private static final class OfConstructorReference
    extends FunctionalReferenceIntrospection {
        private final Constructor<?> implementationConstructor;

        OfConstructorReference(SerializedLambda serializedForm, ClassLoader classLoader) {
            super(serializedForm, classLoader);
            MethodSignature signature = MethodSignature.read(this.serializedForm.getInstantiatedMethodType());
            this.implementationConstructor = (Constructor)((ConstructorQuery)ConstructorQuery.of(this.getImplementationClass()).parameters(signature.runtimeParameterTypes(classLoader))).asAccessible().unique();
        }

        @Override
        public Method referencedMethod() throws IllegalStateException {
            throw new IllegalStateException("Interface implementation is not a method reference");
        }

        @Override
        public Constructor<?> referencedConstructor() {
            return this.implementationConstructor;
        }

        @Override
        public <T> T visit(FunctionalReference.Visitor<T> visitor) {
            return visitor.visitConstructor(this.implementationConstructor);
        }

        @Override
        public Class<?> resultType() {
            return this.implementationConstructor.getDeclaringClass();
        }

        @Override
        public int parametersCount() {
            return this.implementationConstructor.getParameterCount();
        }

        @Override
        public Type parameterType(int index) {
            this.checkParameterNumber(index);
            return this.implementationConstructor.getGenericParameterTypes()[index];
        }

        @Override
        public Set<Annotation> parameterAnnotations(int index) {
            this.checkParameterNumber(index);
            Object[] annotations = this.implementationConstructor.getParameterAnnotations()[index];
            return ImmutableSet.copyOf((Object[])annotations);
        }
    }

    private static final class OfLambda
    extends OfMethod {
        private final ImmutableList<Object> captures;

        OfLambda(SerializedLambda serializedForm, ClassLoader classLoader) {
            super(serializedForm, classLoader);
            ImmutableList.Builder result = ImmutableList.builder();
            for (int i = 0; i < this.serializedForm.getCapturedArgCount(); ++i) {
                Object capturedArg = this.serializedForm.getCapturedArg(i);
                result.add(capturedArg);
            }
            this.captures = result.build();
        }

        @Override
        public <T> T visit(FunctionalReference.Visitor<T> visitor) {
            return visitor.visitLambda(this.implementationMethod, (List<Object>)this.captures);
        }

        @Override
        public Method referencedMethod() throws IllegalStateException {
            throw new IllegalStateException("Interface implementation is not a method reference");
        }
    }

    private static final class OfStaticMethod
    extends OfMethod {
        OfStaticMethod(SerializedLambda serializedForm, ClassLoader classLoader) {
            super(serializedForm, classLoader);
        }

        @Override
        public <T> T visit(FunctionalReference.Visitor<T> visitor) {
            return visitor.visitStatic(this.implementationMethod);
        }
    }

    private static final class OfBoundMethod
    extends OfMethod {
        OfBoundMethod(SerializedLambda serializedForm, ClassLoader classLoader) {
            super(serializedForm, classLoader);
        }

        @Override
        public <T> T visit(FunctionalReference.Visitor<T> visitor) {
            Object boundInstance = this.serializedForm.getCapturedArg(0);
            return visitor.visitBound(this.implementationMethod, boundInstance);
        }
    }

    private static final class OfInstanceMethod
    extends OfMethod {
        OfInstanceMethod(SerializedLambda serializedForm, ClassLoader classLoader) {
            super(serializedForm, classLoader);
        }

        @Override
        public <T> T visit(FunctionalReference.Visitor<T> visitor) {
            return visitor.visitInstance(this.implementationMethod);
        }

        @Override
        public int parametersCount() {
            return this.implementationMethod.getParameterCount() + 1;
        }

        @Override
        public Type parameterType(int index) {
            this.checkParameterNumber(index);
            if (index == 0) {
                return this.implementationClass;
            }
            return this.implementationMethod.getGenericParameterTypes()[index - 1];
        }

        @Override
        public Set<Annotation> parameterAnnotations(int index) {
            this.checkParameterNumber(index);
            if (index == 0) {
                return ImmutableSet.of();
            }
            Object[] parameterAnnotations = this.implementationMethod.getParameterAnnotations()[index - 1];
            return ImmutableSet.copyOf((Object[])parameterAnnotations);
        }
    }

    private static abstract class OfMethod
    extends FunctionalReferenceIntrospection {
        protected final Method implementationMethod;

        OfMethod(SerializedLambda serializedForm, ClassLoader classLoader) {
            super(serializedForm, classLoader);
            String methodName = serializedForm.getImplMethodName();
            MethodSignature signature = MethodSignature.read(serializedForm.getImplMethodSignature());
            this.implementationMethod = (Method)MethodQuery.of(this.implementationClass).named(methodName).parameters(ParametersFilter.typesExact(signature.runtimeParameterTypes(classLoader))).returning(TypeFilter.exact(signature.runtimeResultType(classLoader))).notOverridden().asAccessible().unique();
        }

        @Override
        public int parametersCount() {
            return this.implementationMethod.getParameterCount();
        }

        @Override
        public Type parameterType(int index) {
            this.checkParameterNumber(index);
            return this.implementationMethod.getGenericParameterTypes()[index];
        }

        @Override
        public Set<Annotation> parameterAnnotations(int index) {
            this.checkParameterNumber(index);
            Object[] annotations = this.implementationMethod.getParameterAnnotations()[index];
            return ImmutableSet.copyOf((Object[])annotations);
        }

        @Override
        public Method referencedMethod() throws IllegalStateException {
            return this.implementationMethod;
        }

        @Override
        public final Type resultType() {
            return this.implementationMethod.getGenericReturnType();
        }
    }
}

