/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Array;
import java.util.Collection;

final class MethodSignature {
    static final CharMatcher IDENTIFIER_BREAKING = CharMatcher.anyOf((CharSequence)";.[:><").or(CharMatcher.whitespace());
    private final ImmutableList<TypeParameter> formalTypeParameters;
    private final ImmutableList<FieldType> formalParameters;
    private final ReturnType returnType;
    private final ImmutableList<FieldType> thrownTypes;

    static MethodSignature read(String signatureString) {
        CharacterReader reader = new CharacterReader(signatureString);
        ImmutableList<TypeParameter> typeParameters = TypeParameter.readFormalTypeParametersFrom(reader);
        ImmutableList<FieldType> formalParameters = MethodSignature.parseFormalParameters(reader);
        ReturnType returnType = ReturnType.readReturnTypeFrom(reader);
        ImmutableList<FieldType> thrownTypes = MethodSignature.parseThrownTypes(reader);
        return new MethodSignature(typeParameters, formalParameters, returnType, thrownTypes);
    }

    private MethodSignature(ImmutableList<TypeParameter> typeParameters, ImmutableList<FieldType> formalParameters, ReturnType returnType, ImmutableList<FieldType> thrownTypes) {
        this.formalTypeParameters = typeParameters;
        this.formalParameters = formalParameters;
        this.returnType = returnType;
        this.thrownTypes = thrownTypes;
    }

    public Class<?>[] runtimeParameterTypes(ClassLoader loader) {
        return (Class[])this.formalParameters.stream().map(typeSignature -> typeSignature.asRuntimeClass(loader, (Collection<TypeParameter>)this.formalTypeParameters)).toArray(Class[]::new);
    }

    public Class<?> runtimeResultType(ClassLoader loader) {
        return this.returnType.asRuntimeClass(loader, (Collection<TypeParameter>)this.formalTypeParameters);
    }

    public Class<?>[] runtimeDeclaredExceptionTypes(ClassLoader loader) {
        return (Class[])this.thrownTypes.stream().map(fieldType -> fieldType.asRuntimeClass(loader, (Collection<TypeParameter>)this.formalTypeParameters)).toArray(Class[]::new);
    }

    private static ImmutableList<FieldType> parseFormalParameters(CharacterReader reader) {
        reader.advanceAssuming('(');
        ImmutableList.Builder typeSignatures = ImmutableList.builder();
        while (!reader.currentIs(')')) {
            FieldType typeSignature = FieldType.readFieldTypeFrom(reader);
            typeSignatures.add((Object)typeSignature);
        }
        ImmutableList signatures = typeSignatures.build();
        reader.advanceAssuming(')');
        return signatures;
    }

    private static ImmutableList<FieldType> parseThrownTypes(CharacterReader reader) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        while (reader.currentIsThenSkip('^')) {
            FieldType throwsSignature = FieldType.readFieldTypeFrom(reader);
            if (throwsSignature instanceof ArrayType) {
                throw new IllegalArgumentException("Throws cannot be array");
            }
            resultBuilder.add((Object)throwsSignature);
        }
        return resultBuilder.build();
    }

    private static final class PrimitiveType
    implements FieldType {
        static final CharMatcher CHARACTERS = CharMatcher.anyOf((CharSequence)"BCDFIJSZ");
        static final PrimitiveType BYTE = new PrimitiveType(Byte.TYPE);
        static final PrimitiveType CHAR = new PrimitiveType(Character.TYPE);
        static final PrimitiveType DOUBLE = new PrimitiveType(Double.TYPE);
        static final PrimitiveType FLOAT = new PrimitiveType(Float.TYPE);
        static final PrimitiveType INT = new PrimitiveType(Integer.TYPE);
        static final PrimitiveType LONG = new PrimitiveType(Long.TYPE);
        static final PrimitiveType SHORT = new PrimitiveType(Short.TYPE);
        static final PrimitiveType BOOLEAN = new PrimitiveType(Boolean.TYPE);
        private final Class<?> type;

        static PrimitiveType readPrimitiveSignature(CharacterReader reader) {
            if (reader.currentIsThenSkip('B')) {
                return BYTE;
            }
            if (reader.currentIsThenSkip('C')) {
                return CHAR;
            }
            if (reader.currentIsThenSkip('D')) {
                return DOUBLE;
            }
            if (reader.currentIsThenSkip('F')) {
                return FLOAT;
            }
            if (reader.currentIsThenSkip('I')) {
                return INT;
            }
            if (reader.currentIsThenSkip('J')) {
                return LONG;
            }
            if (reader.currentIsThenSkip('S')) {
                return SHORT;
            }
            if (reader.currentIsThenSkip('Z')) {
                return BOOLEAN;
            }
            throw new IllegalArgumentException("expected primitive type");
        }

        private PrimitiveType(Class<?> type) {
            this.type = type;
        }

        @Override
        public Class<?> asRuntimeClass(ClassLoader loader, Collection<TypeParameter> formals) {
            return this.type;
        }
    }

    private static final class TypeVariable
    implements FieldType {
        private final String identifier;

        private TypeVariable(String identifier) {
            this.identifier = identifier;
        }

        private static TypeVariable readTypeVariableSignature(CharacterReader reader) {
            reader.advanceAssuming('T');
            String identifier = reader.readUntil(IDENTIFIER_BREAKING);
            TypeVariable typeVariableSignature = new TypeVariable(identifier);
            reader.advanceAssuming(';');
            return typeVariableSignature;
        }

        @Override
        public Class<?> asRuntimeClass(ClassLoader loader, Collection<TypeParameter> formals) {
            TypeParameter typeParameter = formals.stream().filter(formal -> formal.hasIdentifier(this.identifier)).findAny().orElseThrow(() -> new IllegalArgumentException("Cannot resolve parameter " + this.identifier));
            return typeParameter.firstBound().asRuntimeClass(loader, formals);
        }
    }

    private static final class ObjectType
    implements FieldType {
        static final ObjectType OBJECT = ObjectType.createWithoutTypeArguments("java.lang.Object");
        private final String className;
        private final ImmutableList<TypeArgument> typeArguments;

        private ObjectType(String className, ImmutableList<TypeArgument> typeArguments) {
            this.className = className;
            this.typeArguments = typeArguments;
        }

        static ObjectType readSimpleClassTypeSignature(CharacterReader reader) {
            reader.advanceAssuming('L');
            String identifier = reader.readUntil(IDENTIFIER_BREAKING);
            String qualified = identifier.replaceAll("/", ".");
            if (reader.currentIsThenSkip(';')) {
                return ObjectType.createWithoutTypeArguments(qualified);
            }
            if (reader.currentIs('<')) {
                ImmutableList<TypeArgument> typeArguments = TypeArgument.readTypeArgumentsFrom(reader);
                reader.advanceAssuming(';');
                return ObjectType.create(qualified, typeArguments);
            }
            throw new IllegalArgumentException("expected '<' or ';' or '.'");
        }

        static ObjectType create(String identifier, ImmutableList<TypeArgument> typeArguments) {
            return new ObjectType(identifier, typeArguments);
        }

        static ObjectType createWithoutTypeArguments(String identifier) {
            return new ObjectType(identifier, (ImmutableList<TypeArgument>)ImmutableList.of());
        }

        @Override
        public Class<?> asRuntimeClass(ClassLoader loader, Collection<TypeParameter> formals) {
            try {
                return loader.loadClass(this.className);
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private static final class TypeParameter
    implements TypeArgument {
        private final String identifier;
        private final ImmutableList<FieldType> bounds;

        private TypeParameter(String identifier, ImmutableList<FieldType> bounds) {
            this.identifier = identifier;
            this.bounds = bounds;
        }

        static ImmutableList<TypeParameter> readFormalTypeParametersFrom(CharacterReader reader) {
            if (!reader.currentIsThenSkip('<')) {
                return ImmutableList.of();
            }
            ImmutableList.Builder resultBuilder = ImmutableList.builder();
            while (!reader.currentIs('>')) {
                TypeParameter typeParameter = TypeParameter.readFormalTypeParameterFrom(reader);
                resultBuilder.add((Object)typeParameter);
            }
            reader.advanceAssuming('>');
            return resultBuilder.build();
        }

        static TypeParameter readFormalTypeParameterFrom(CharacterReader reader) {
            FieldType bound;
            String identifier = reader.readUntil(IDENTIFIER_BREAKING);
            ImmutableList.Builder boundsBuilder = ImmutableList.builder();
            reader.advanceAssuming(':');
            if (!reader.currentIs(':')) {
                bound = FieldType.readFieldTypeFrom(reader);
                boundsBuilder.add((Object)bound);
            }
            while (reader.currentIsThenSkip(':')) {
                bound = FieldType.readFieldTypeFrom(reader);
                boundsBuilder.add((Object)bound);
            }
            ImmutableList bounds = boundsBuilder.build();
            return new TypeParameter(identifier, (ImmutableList<FieldType>)bounds);
        }

        FieldType firstBound() {
            if (this.bounds.isEmpty()) {
                return ObjectType.OBJECT;
            }
            return (FieldType)this.bounds.get(0);
        }

        boolean hasIdentifier(String candidate) {
            return this.identifier.equals(candidate);
        }
    }

    private static final class ArrayType
    implements FieldType {
        private final FieldType nested;

        private ArrayType(FieldType nested) {
            this.nested = nested;
        }

        @Override
        public Class<?> asRuntimeClass(ClassLoader loader, Collection<TypeParameter> formals) {
            Class<?> componentType = this.nested.asRuntimeClass(loader, formals);
            return Array.newInstance(componentType, 0).getClass();
        }

        static ArrayType readArrayTypeSignatureFrom(CharacterReader reader) {
            reader.advanceAssuming('[');
            FieldType nested = FieldType.readFieldTypeFrom(reader);
            return new ArrayType(nested);
        }
    }

    private static interface FieldType
    extends ReturnType,
    TypeArgument {
        public static FieldType readFieldTypeFrom(CharacterReader reader) {
            if (reader.currentIs('L')) {
                return ObjectType.readSimpleClassTypeSignature(reader);
            }
            if (reader.currentIs('T')) {
                return TypeVariable.readTypeVariableSignature(reader);
            }
            if (reader.currentIs('[')) {
                return ArrayType.readArrayTypeSignatureFrom(reader);
            }
            if (reader.currentIn(PrimitiveType.CHARACTERS)) {
                return PrimitiveType.readPrimitiveSignature(reader);
            }
            throw new IllegalArgumentException("Expected Field Type Signature");
        }
    }

    private static interface ReturnType {
        public static final ReturnType VOID = new ReturnType(){

            @Override
            public Class<?> asRuntimeClass(ClassLoader loader, Collection<TypeParameter> formals) {
                return Void.TYPE;
            }
        };

        public Class<?> asRuntimeClass(ClassLoader var1, Collection<TypeParameter> var2);

        public static ReturnType readReturnTypeFrom(CharacterReader reader) {
            if (reader.currentIsThenSkip('V')) {
                return VOID;
            }
            return FieldType.readFieldTypeFrom(reader);
        }
    }

    private static abstract class Wildcard
    implements TypeArgument {
        Wildcard() {
        }

        static Wildcard createWild() {
            return new Wildcard(){};
        }

        static Wildcard createWithUpperBound(FieldType upper) {
            return new Wildcard(){};
        }

        static Wildcard createWithLowerBound(FieldType lower) {
            return new Wildcard(){};
        }
    }

    private static interface TypeArgument {
        public static TypeArgument readTypeArgumentFrom(CharacterReader reader) {
            if (reader.currentIsThenSkip('*')) {
                return Wildcard.createWild();
            }
            if (reader.currentIsThenSkip('+')) {
                FieldType upper = FieldType.readFieldTypeFrom(reader);
                return Wildcard.createWithUpperBound(upper);
            }
            if (reader.currentIsThenSkip('-')) {
                FieldType lower = FieldType.readFieldTypeFrom(reader);
                return Wildcard.createWithLowerBound(lower);
            }
            return FieldType.readFieldTypeFrom(reader);
        }

        public static ImmutableList<TypeArgument> readTypeArgumentsFrom(CharacterReader reader) {
            reader.advanceAssuming('<');
            ImmutableList.Builder typeArgumentBuilder = ImmutableList.builder();
            while (!reader.currentIs('>')) {
                TypeArgument typeArgument = TypeArgument.readTypeArgumentFrom(reader);
                typeArgumentBuilder.add((Object)typeArgument);
            }
            reader.advanceAssuming('>');
            return typeArgumentBuilder.build();
        }
    }

    private static final class CharacterReader {
        private final char[] input;
        private int position;

        CharacterReader(String input) {
            this.input = input.toCharArray();
        }

        void advanceAssuming(char expected) {
            if (!this.currentIs(expected)) {
                throw new IllegalArgumentException("Expected " + expected);
            }
            ++this.position;
        }

        String readUntil(CharMatcher breaking) {
            char current;
            StringBuilder result = new StringBuilder();
            while (this.position < this.input.length && !breaking.matches(current = this.input[this.position])) {
                result.append(current);
                ++this.position;
            }
            return result.toString();
        }

        private boolean currentIs(char expected) {
            return this.currentIn(CharMatcher.is((char)expected));
        }

        boolean currentIn(CharMatcher characters) {
            if (this.position >= this.input.length) {
                return false;
            }
            char current = this.input[this.position];
            return characters.matches(current);
        }

        boolean currentIsThenSkip(char expected) {
            if (!this.currentIs(expected)) {
                return false;
            }
            ++this.position;
            return true;
        }
    }
}

