/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.bean;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import org.perfectable.introspection.bean.BeanSchema;
import org.perfectable.introspection.bean.Properties;
import org.perfectable.introspection.bean.Property;
import org.perfectable.introspection.query.FieldQuery;

public final class Bean<B> {
    private final B instance;

    private Bean(B instance) {
        this.instance = instance;
    }

    public static <X> Bean<X> from(X instance) {
        Objects.requireNonNull(instance);
        return new Bean<X>(instance);
    }

    public B contents() {
        return this.instance;
    }

    public Class<B> type() {
        return this.instance.getClass();
    }

    public Property<B, Object> property(String name) {
        return Properties.create(this.type(), name).bind(this.instance);
    }

    public Bean<B> copy() {
        Bean duplicate = BeanSchema.from(this.type()).instantiate();
        this.fieldProperties().forEach(property -> property.copy(duplicate));
        return duplicate;
    }

    public ImmutableSet<Property<B, ?>> fieldProperties() {
        return (ImmutableSet)FieldQuery.of(this.type()).excludingModifier(8).stream().map(field -> Properties.fromField(field).bind(this.instance)).collect(ImmutableSet.toImmutableSet());
    }

    public ImmutableSet<Object> related() {
        return (ImmutableSet)this.fieldProperties().stream().map(Property::get).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Bean)) {
            return false;
        }
        Bean other = (Bean)obj;
        return this.instance.equals(other.instance);
    }

    public int hashCode() {
        return Objects.hash(this.instance);
    }
}

