/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.bean;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.perfectable.introspection.Introspections;
import org.perfectable.introspection.bean.Bean;
import org.perfectable.introspection.bean.Properties;
import org.perfectable.introspection.bean.PropertySchema;

public final class BeanSchema<B> {
    private final Class<B> beanClass;

    public static <X> BeanSchema<X> from(Class<X> beanClass) {
        Objects.requireNonNull(beanClass);
        return new BeanSchema<X>(beanClass);
    }

    private BeanSchema(Class<B> beanClass) {
        this.beanClass = beanClass;
    }

    public Bean<B> put(B element) {
        Preconditions.checkArgument((boolean)this.beanClass.isInstance(element));
        return Bean.from(element);
    }

    public Class<B> type() {
        return this.beanClass;
    }

    public Bean<B> instantiate() {
        B instance = Introspections.introspect(this.beanClass).instantiate();
        return Bean.from(instance);
    }

    public PropertySchema<B, ?> property(String name) {
        return Properties.create(this.beanClass, name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BeanSchema)) {
            return false;
        }
        BeanSchema other = (BeanSchema)obj;
        return this.beanClass.equals(other.beanClass);
    }

    public int hashCode() {
        return Objects.hash(this.beanClass);
    }
}

