/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.bean;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.perfectable.introspection.Introspections;
import org.perfectable.introspection.PrivilegedActions;
import org.perfectable.introspection.bean.PropertySchema;
import org.perfectable.introspection.query.MethodQuery;

final class Properties {
    private static final String BOOLEAN_GETTER_PREFIX = "is";
    private static final String STANDARD_GETTER_PREFIX = "get";
    private static final String SETTER_PREFIX = "set";

    static <T> PropertySchema<T, Object> fromField(Field field) {
        PrivilegedActions.markAccessible(field);
        return new FieldPropertySchema(field);
    }

    static <CX> PropertySchema<CX, Object> create(Class<CX> beanClass, String name) {
        Objects.requireNonNull(beanClass);
        Optional field = Introspections.introspect(beanClass).fields().named(name).option();
        if (field.isPresent()) {
            return Properties.fromField((Field)field.get());
        }
        Optional<Method> getterOption = Properties.findGetter(beanClass, name);
        Optional<Method> setterOption = Properties.findSetter(beanClass, name);
        if (setterOption.isPresent() && getterOption.isPresent()) {
            Method getter = getterOption.get();
            Method setter = setterOption.get();
            ReadWriteMethodPropertySchema.checkCompatibility(getter, setter);
            return new ReadWriteMethodPropertySchema(getter, setter);
        }
        if (getterOption.isPresent()) {
            Method getter = getterOption.get();
            PrivilegedActions.markAccessible(getter);
            return new ReadOnlyMethodPropertySchema(getter);
        }
        if (setterOption.isPresent()) {
            Method setter = setterOption.get();
            PrivilegedActions.markAccessible(setter);
            return new WriteOnlyMethodPropertySchema(setter);
        }
        throw new IllegalArgumentException("No property " + name + " for " + beanClass);
    }

    private static Optional<Method> findGetter(Class<?> beanClass, String name) {
        Pattern getterNamePattern = Pattern.compile("(?:is|get)" + Pattern.quote(Properties.capitalize(name)));
        return ((MethodQuery)Introspections.introspect(beanClass).methods().nameMatching(getterNamePattern).parameters(new Type[0])).option();
    }

    private static Optional<Method> findSetter(Class<?> beanClass, String name) {
        String setterName = Properties.setterName(name);
        return ((MethodQuery)Introspections.introspect(beanClass).methods().named(setterName).parameterCount(1)).returningVoid().option();
    }

    private static String propertyNameFromGetter(Method getter) {
        String unformatted = getter.getName();
        int prefixLength = Properties.getterPrefix(getter.getReturnType()).length();
        return String.valueOf(unformatted.charAt(prefixLength)).toLowerCase(Locale.ROOT) + unformatted.substring(prefixLength + 1);
    }

    private static String propertyNameFromSetter(Method setter) {
        String unformatted = setter.getName();
        int prefixLength = SETTER_PREFIX.length();
        return String.valueOf(unformatted.charAt(prefixLength)).toLowerCase(Locale.ROOT) + unformatted.substring(prefixLength + 1);
    }

    private static String setterName(String name) {
        return SETTER_PREFIX + Properties.capitalize(name);
    }

    private static String getterPrefix(Class<?> returnType) {
        boolean returnsBoolean = Boolean.class.equals(returnType) || Boolean.TYPE.equals(returnType);
        return returnsBoolean ? BOOLEAN_GETTER_PREFIX : STANDARD_GETTER_PREFIX;
    }

    private static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase(Locale.ROOT) + name.substring(1);
    }

    private Properties() {
    }

    static final class ReadWriteMethodPropertySchema<CT, PT>
    extends PropertySchema<CT, PT> {
        private final Method getter;
        private final Method setter;

        ReadWriteMethodPropertySchema(Method getter, Method setter) {
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        @Nullable
        public PT get(CT bean) {
            try {
                return (PT)this.getter.invoke(bean, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                Throwables.throwIfUnchecked((Throwable)e.getTargetException());
                throw new RuntimeException(e.getTargetException());
            }
        }

        @Override
        public void set(CT bean, @Nullable PT value) {
            try {
                this.setter.invoke(bean, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                Throwables.throwIfUnchecked((Throwable)e.getTargetException());
                throw new RuntimeException(e.getTargetException());
            }
        }

        @Override
        public String name() {
            return Properties.propertyNameFromGetter(this.getter);
        }

        @Override
        public Class<PT> type() {
            return this.getter.getReturnType();
        }

        @Override
        public boolean isReadable() {
            return Introspections.introspect(this.getter).isCallable();
        }

        @Override
        public boolean isWritable() {
            return Introspections.introspect(this.setter).isCallable();
        }

        private static void checkCompatibility(Method getter, Method setter) {
            Class<?> getterReturnType = getter.getReturnType();
            Class<?> setterAcceptType = setter.getParameterTypes()[0];
            Preconditions.checkArgument((boolean)getterReturnType.equals(setterAcceptType));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ReadWriteMethodPropertySchema)) {
                return false;
            }
            ReadWriteMethodPropertySchema other = (ReadWriteMethodPropertySchema)obj;
            return Objects.equals(this.getter, other.getter) && Objects.equals(this.setter, other.setter);
        }

        public int hashCode() {
            return Objects.hash(this.getter, this.setter);
        }
    }

    static final class WriteOnlyMethodPropertySchema<CT, PT>
    extends PropertySchema<CT, PT> {
        private final Method setter;

        WriteOnlyMethodPropertySchema(Method setter) {
            this.setter = Objects.requireNonNull(setter);
        }

        @Override
        @Nullable
        public PT get(CT bean) {
            throw new IllegalStateException("Property is not readable");
        }

        @Override
        public void set(CT bean, @Nullable PT value) {
            try {
                this.setter.invoke(bean, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                Throwables.throwIfUnchecked((Throwable)e.getTargetException());
                throw new RuntimeException(e.getTargetException());
            }
        }

        @Override
        public String name() {
            return Properties.propertyNameFromSetter(this.setter);
        }

        @Override
        public Class<PT> type() {
            Class<?>[] parameterTypes = this.setter.getParameterTypes();
            Class<?> firstParameterType = parameterTypes[0];
            return firstParameterType;
        }

        @Override
        public boolean isReadable() {
            return false;
        }

        @Override
        public boolean isWritable() {
            return Introspections.introspect(this.setter).isCallable();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WriteOnlyMethodPropertySchema)) {
                return false;
            }
            WriteOnlyMethodPropertySchema other = (WriteOnlyMethodPropertySchema)obj;
            return Objects.equals(this.setter, other.setter);
        }

        public int hashCode() {
            return Objects.hash(this.setter);
        }
    }

    static final class ReadOnlyMethodPropertySchema<CT, PT>
    extends PropertySchema<CT, PT> {
        private final Method getter;

        ReadOnlyMethodPropertySchema(Method getter) {
            this.getter = Objects.requireNonNull(getter);
        }

        @Override
        @Nullable
        public PT get(CT bean) {
            try {
                return (PT)this.getter.invoke(bean, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                Throwables.throwIfUnchecked((Throwable)e.getTargetException());
                throw new RuntimeException(e.getTargetException());
            }
        }

        @Override
        public void set(CT bean, @Nullable PT value) {
            throw new IllegalStateException("Property is not writable");
        }

        @Override
        public String name() {
            return Properties.propertyNameFromGetter(this.getter);
        }

        @Override
        public Class<PT> type() {
            Class<?> resultType = this.getter.getReturnType();
            return Objects.requireNonNull(resultType);
        }

        @Override
        public boolean isReadable() {
            return Introspections.introspect(this.getter).isCallable();
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ReadOnlyMethodPropertySchema)) {
                return false;
            }
            ReadOnlyMethodPropertySchema other = (ReadOnlyMethodPropertySchema)obj;
            return Objects.equals(this.getter, other.getter);
        }

        public int hashCode() {
            return Objects.hash(this.getter);
        }
    }

    static final class FieldPropertySchema<CT, PT>
    extends PropertySchema<CT, PT> {
        private final Field field;

        FieldPropertySchema(Field field) {
            this.field = field;
        }

        @Override
        void set(CT bean, @Nullable PT value) {
            try {
                this.field.set(bean, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        @Nullable
        PT get(CT bean) {
            try {
                return (PT)this.field.get(bean);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String name() {
            return this.field.getName();
        }

        @Override
        public Class<PT> type() {
            return this.field.getType();
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return !Modifier.isFinal(this.field.getModifiers());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FieldPropertySchema)) {
                return false;
            }
            FieldPropertySchema other = (FieldPropertySchema)obj;
            return Objects.equals(this.field, other.field);
        }

        public int hashCode() {
            return Objects.hash(this.field);
        }
    }
}

