/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.bean;

import java.lang.reflect.Type;
import java.util.Objects;
import javax.annotation.Nullable;
import org.perfectable.introspection.bean.Bean;
import org.perfectable.introspection.bean.PropertySchema;

public final class Property<B, T> {
    private final B bean;
    private final PropertySchema<B, T> schema;

    static <B, T> Property<B, T> of(B bean, PropertySchema<B, T> schema) {
        Objects.requireNonNull(bean);
        Objects.requireNonNull(schema);
        return new Property<B, T>(bean, schema);
    }

    private Property(B bean, PropertySchema<B, T> schema) {
        this.bean = bean;
        this.schema = schema;
    }

    public <X extends T> Property<B, X> as(Class<X> newValueType) {
        return this.schema.as(newValueType).bind(this.bean);
    }

    @Nullable
    public T get() {
        return this.schema.get(this.bean);
    }

    public void set(@Nullable T value) {
        this.schema.set(this.bean, value);
    }

    public Type type() {
        return this.schema.type();
    }

    public String name() {
        return this.schema.name();
    }

    public boolean isReadable() {
        return this.schema.isReadable();
    }

    public boolean isWritable() {
        return this.schema.isWritable();
    }

    public void copy(Bean<B> other) {
        T value = this.get();
        this.schema.set(other.contents(), value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Property)) {
            return false;
        }
        Property other = (Property)obj;
        return Objects.equals(this.schema, other.schema) && Objects.equals(this.bean, other.bean);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.bean);
    }
}

